create table SYS_PERSONALITY_SETTINGS
(
    ID                 NUMBER(20) not null,
    P_ID               NUMBER(20) not null,
    R_ID               NUMBER(20),
    PERM_LEVEL         NUMBER(11),
    SORT_NO            NUMBER(11) not null,
    TENANT_ID          NUMBER(20),
    REMARK             NVARCHAR2(255),
    CREATE_USER_ID     NUMBER(20),
    CREATOR            NVARCHAR2(255),
    CREATE_TIME        DATE,
    MODIFY_USER_ID     NUMBER(20),
    UPDATER            NVARCHAR2(255),
    MODIFY_TIME        DATE,
    DELETE_FLAG        NUMBER(11),
    AUDIT_DATA_VERSION NUMBER(11),
    SEC_BU_ID          NUMBER(20),
    SEC_USER_ID        NUMBER(20),
    SEC_OU_ID          NUMBER(20),
    PERSONALITY        NVARCHAR2(40),
    IS_QUICK           NUMBER(11)
)
/

comment on table SYS_PERSONALITY_SETTINGS is '系统快捷入口配置'
/

comment on column SYS_PERSONALITY_SETTINGS.ID is '记录唯一ID'
/

comment on column SYS_PERSONALITY_SETTINGS.P_ID is '权限id'
/

comment on column SYS_PERSONALITY_SETTINGS.R_ID is '用户ID'
/

comment on column SYS_PERSONALITY_SETTINGS.PERM_LEVEL is '权限层级'
/

comment on column SYS_PERSONALITY_SETTINGS.SORT_NO is '排列顺序'
/

comment on column SYS_PERSONALITY_SETTINGS.TENANT_ID is '租户ID'
/

comment on column SYS_PERSONALITY_SETTINGS.REMARK is '备注'
/

comment on column SYS_PERSONALITY_SETTINGS.CREATE_USER_ID is '记录创建者ID'
/

comment on column SYS_PERSONALITY_SETTINGS.CREATOR is '记录创建者'
/

comment on column SYS_PERSONALITY_SETTINGS.CREATE_TIME is '记录创建时间'
/

comment on column SYS_PERSONALITY_SETTINGS.MODIFY_USER_ID is '记录最后更新者ID'
/

comment on column SYS_PERSONALITY_SETTINGS.UPDATER is '记录最后更新者'
/

comment on column SYS_PERSONALITY_SETTINGS.MODIFY_TIME is '记录最后更新时间'
/

comment on column SYS_PERSONALITY_SETTINGS.DELETE_FLAG is '逻辑删除，0：未删除，1：已删除'
/

comment on column SYS_PERSONALITY_SETTINGS.AUDIT_DATA_VERSION is '锁版本'
/

comment on column SYS_PERSONALITY_SETTINGS.SEC_BU_ID is 'sec_bu_id'
/

comment on column SYS_PERSONALITY_SETTINGS.SEC_USER_ID is 'sec_user_id'
/

comment on column SYS_PERSONALITY_SETTINGS.SEC_OU_ID is 'sec_ou_id'
/

comment on column SYS_PERSONALITY_SETTINGS.PERSONALITY is '个性化设置'
/

comment on column SYS_PERSONALITY_SETTINGS.IS_QUICK is '是否快捷'
/

