create table SYS_QUICK_ENTRY
(
    ID                 NUMBER(19) not null
        constraint PK_SYS_QUICK_ENTRY
            primary key,
    QUICK_DATA         NVARCHAR2(1024),
    TENANT_ID          NUMBER(19),
    REMARK             NVARCHAR2(255),
    CREATE_USER_ID     NUMBER(19),
    CREATOR            NVARCHAR2(255),
    CREATE_TIME        DATE,
    MODIFY_USER_ID     NUMBER(19),
    UPDATER            NVARCHAR2(255),
    MODIFY_TIME        DATE,
    DELETE_FLAG        NUMBER(10) default '0',
    AUDIT_DATA_VERSION NUMBER(10),
    SEC_BU_ID          NUMBER(19),
    SEC_USER_ID        NUMBER(19),
    SEC_OU_ID          NUMBER(19),
    TERMINAL_CODE      NVARCHAR2(22)
)
/

comment on table SYS_QUICK_ENTRY is '系统快捷入口配置'
/

comment on column SYS_QUICK_ENTRY.ID is '记录唯一ID'
/

comment on column SYS_QUICK_ENTRY.QUICK_DATA is '快捷入口数据：前端传递，后端直接返回'
/

comment on column SYS_QUICK_ENTRY.TENANT_ID is '租户ID'
/

comment on column SYS_QUICK_ENTRY.REMARK is '备注'
/

comment on column SYS_QUICK_ENTRY.CREATE_USER_ID is '记录创建者ID'
/

comment on column SYS_QUICK_ENTRY.CREATOR is '记录创建者'
/

comment on column SYS_QUICK_ENTRY.CREATE_TIME is '记录创建时间'
/

comment on column SYS_QUICK_ENTRY.MODIFY_USER_ID is '记录最后更新者ID'
/

comment on column SYS_QUICK_ENTRY.UPDATER is '记录最后更新者'
/

comment on column SYS_QUICK_ENTRY.MODIFY_TIME is '记录最后更新时间'
/

comment on column SYS_QUICK_ENTRY.DELETE_FLAG is '逻辑删除，0：未删除，1：已删除'
/

comment on column SYS_QUICK_ENTRY.AUDIT_DATA_VERSION is '锁版本'
/

comment on column SYS_QUICK_ENTRY.SEC_BU_ID is 'sec_bu_id'
/

comment on column SYS_QUICK_ENTRY.SEC_USER_ID is 'sec_user_id'
/

comment on column SYS_QUICK_ENTRY.SEC_OU_ID is 'sec_ou_id'
/

comment on column SYS_QUICK_ENTRY.TERMINAL_CODE is '终端编码Terminal枚举类R'
/

