create table SYS_ROCKET_MQ_CONSUME_FAIL_LOG
(
    ID                 NUMBER(19) not null
        constraint PK_SYS_ROCKET_MQ_CONSUME_FAIL_
            primary key,
    TYPE_ID            NUMBER(10),
    ALREADY_DEAL       NVARCHAR2(255),
    CONSUMER_KYE       NVARCHAR2(64),
    CONSUMER_GROUP     NVARCHAR2(256),
    CONSUMER_TOPIC     NVARCHAR2(128),
    MESSAGE_DETAIL     NVARCHAR2(1024),
    TENANT_ID          NUMBER(19),
    REMARK             NVARCHAR2(255),
    CREATE_USER_ID     NUMBER(19),
    CREATOR            NVARCHAR2(255),
    CREATE_TIME        DATE,
    MODIFY_USER_ID     NUMBER(19),
    UPDATER            NVARCHAR2(255),
    MODIFY_TIME        DATE,
    DELETE_FLAG        NUMBER(10) default '0',
    AUDIT_DATA_VERSION NUMBER(10),
    SEC_BU_ID          NUMBER(19),
    SEC_USER_ID        NUMBER(19),
    SEC_OU_ID          NUMBER(19),
    CONSUMER_KEY       NVARCHAR2(64),
    CONSUMER_BOBY      BLOB,
    CONSUMER_TAG       NVARCHAR2(128),
    MESSAGE_UUID       NVARCHAR2(255)
)
/

comment on table SYS_ROCKET_MQ_CONSUME_FAIL_LOG is '架构补偿机制-消费失败记录'
/

comment on column SYS_ROCKET_MQ_CONSUME_FAIL_LOG.ID is '记录唯一ID'
/

comment on column SYS_ROCKET_MQ_CONSUME_FAIL_LOG.TYPE_ID is '消费失败类型：1：消费次数过多，2：业务异常，3：长时间无法消费,4:其他'
/

comment on column SYS_ROCKET_MQ_CONSUME_FAIL_LOG.ALREADY_DEAL is '消费失败是否已处理；PROCESSED：已处理，TO_BE_PROCESSED:待处理'
/

comment on column SYS_ROCKET_MQ_CONSUME_FAIL_LOG.CONSUMER_KYE is '消息体key'
/

comment on column SYS_ROCKET_MQ_CONSUME_FAIL_LOG.CONSUMER_GROUP is '消费者组'
/

comment on column SYS_ROCKET_MQ_CONSUME_FAIL_LOG.CONSUMER_TOPIC is '消费主题'
/

comment on column SYS_ROCKET_MQ_CONSUME_FAIL_LOG.MESSAGE_DETAIL is '消费数据详情'
/

comment on column SYS_ROCKET_MQ_CONSUME_FAIL_LOG.TENANT_ID is '租户ID'
/

comment on column SYS_ROCKET_MQ_CONSUME_FAIL_LOG.REMARK is '备注'
/

comment on column SYS_ROCKET_MQ_CONSUME_FAIL_LOG.CREATE_USER_ID is '记录创建者ID'
/

comment on column SYS_ROCKET_MQ_CONSUME_FAIL_LOG.CREATOR is '记录创建者'
/

comment on column SYS_ROCKET_MQ_CONSUME_FAIL_LOG.CREATE_TIME is '记录创建时间'
/

comment on column SYS_ROCKET_MQ_CONSUME_FAIL_LOG.MODIFY_USER_ID is '记录最后更新者ID'
/

comment on column SYS_ROCKET_MQ_CONSUME_FAIL_LOG.UPDATER is '记录最后更新者'
/

comment on column SYS_ROCKET_MQ_CONSUME_FAIL_LOG.MODIFY_TIME is '记录最后更新时间'
/

comment on column SYS_ROCKET_MQ_CONSUME_FAIL_LOG.DELETE_FLAG is '逻辑删除，0：未删除，1：已删除'
/

comment on column SYS_ROCKET_MQ_CONSUME_FAIL_LOG.AUDIT_DATA_VERSION is '锁版本'
/

comment on column SYS_ROCKET_MQ_CONSUME_FAIL_LOG.SEC_BU_ID is 'sec_bu_id'
/

comment on column SYS_ROCKET_MQ_CONSUME_FAIL_LOG.SEC_USER_ID is 'sec_user_id'
/

comment on column SYS_ROCKET_MQ_CONSUME_FAIL_LOG.SEC_OU_ID is 'sec_ou_id'
/

comment on column SYS_ROCKET_MQ_CONSUME_FAIL_LOG.CONSUMER_KEY is '消息体key'
/

comment on column SYS_ROCKET_MQ_CONSUME_FAIL_LOG.CONSUMER_BOBY is '消息体'
/

comment on column SYS_ROCKET_MQ_CONSUME_FAIL_LOG.CONSUMER_TAG is 'consumer_tag'
/

comment on column SYS_ROCKET_MQ_CONSUME_FAIL_LOG.MESSAGE_UUID is '消息UUID'
/

create unique index UKGRPK942R3L233CRBYF36P0XPX
    on SYS_ROCKET_MQ_CONSUME_FAIL_LOG (CONSUMER_KEY)
/

