create table SYS_ROCKET_MQ_CONSUME_LOG
(
    ID                 NUMBER(19) not null
        constraint PK_SYS_ROCKET_MQ_CONSUME_LOG
            primary key,
    LINE_NUM           NUMBER(19),
    CONSUMER_KYE       NVARCHAR2(64),
    CONSUMER_GROUP     NVARCHAR2(256),
    CONSUMER_TOPIC     NVARCHAR2(128),
    IS_SUCCESS         NUMBER(10),
    FAIL_DETAIL        NVARCHAR2(255),
    TENANT_ID          NUMBER(19),
    REMARK             NVARCHAR2(255),
    CREATE_USER_ID     NUMBER(19),
    CREATOR            NVARCHAR2(255),
    CREATE_TIME        DATE,
    MODIFY_USER_ID     NUMBER(19),
    UPDATER            NVARCHAR2(255),
    MODIFY_TIME        DATE,
    DELETE_FLAG        NUMBER(10) default '0',
    AUDIT_DATA_VERSION NUMBER(10),
    SEC_BU_ID          NUMBER(19),
    SEC_USER_ID        NUMBER(19),
    SEC_OU_ID          NUMBER(19),
    QUEUE_ID           NUMBER(10),
    MESSAGE_ID         NVARCHAR2(255),
    MESSAGE_UUID       NVARCHAR2(255),
    RECONSUME_TIMES    NUMBER(10),
    CONSUMER_KEY       NVARCHAR2(64)
)
/

comment on table SYS_ROCKET_MQ_CONSUME_LOG is '架构补偿机制-消费记录'
/

comment on column SYS_ROCKET_MQ_CONSUME_LOG.ID is '记录唯一ID'
/

comment on column SYS_ROCKET_MQ_CONSUME_LOG.LINE_NUM is '消息行号'
/

comment on column SYS_ROCKET_MQ_CONSUME_LOG.CONSUMER_KYE is '消息体key'
/

comment on column SYS_ROCKET_MQ_CONSUME_LOG.CONSUMER_GROUP is '消费者组'
/

comment on column SYS_ROCKET_MQ_CONSUME_LOG.CONSUMER_TOPIC is '消费主题'
/

comment on column SYS_ROCKET_MQ_CONSUME_LOG.IS_SUCCESS is '是否消费成功:true:成功，false:失败'
/

comment on column SYS_ROCKET_MQ_CONSUME_LOG.FAIL_DETAIL is '失败详情'
/

comment on column SYS_ROCKET_MQ_CONSUME_LOG.TENANT_ID is '租户ID'
/

comment on column SYS_ROCKET_MQ_CONSUME_LOG.REMARK is '备注'
/

comment on column SYS_ROCKET_MQ_CONSUME_LOG.CREATE_USER_ID is '记录创建者ID'
/

comment on column SYS_ROCKET_MQ_CONSUME_LOG.CREATOR is '记录创建者'
/

comment on column SYS_ROCKET_MQ_CONSUME_LOG.CREATE_TIME is '记录创建时间'
/

comment on column SYS_ROCKET_MQ_CONSUME_LOG.MODIFY_USER_ID is '记录最后更新者ID'
/

comment on column SYS_ROCKET_MQ_CONSUME_LOG.UPDATER is '记录最后更新者'
/

comment on column SYS_ROCKET_MQ_CONSUME_LOG.MODIFY_TIME is '记录最后更新时间'
/

comment on column SYS_ROCKET_MQ_CONSUME_LOG.DELETE_FLAG is '逻辑删除，0：未删除，1：已删除'
/

comment on column SYS_ROCKET_MQ_CONSUME_LOG.AUDIT_DATA_VERSION is '锁版本'
/

comment on column SYS_ROCKET_MQ_CONSUME_LOG.SEC_BU_ID is 'sec_bu_id'
/

comment on column SYS_ROCKET_MQ_CONSUME_LOG.SEC_USER_ID is 'sec_user_id'
/

comment on column SYS_ROCKET_MQ_CONSUME_LOG.SEC_OU_ID is 'sec_ou_id'
/

comment on column SYS_ROCKET_MQ_CONSUME_LOG.QUEUE_ID is '消息体key'
/

comment on column SYS_ROCKET_MQ_CONSUME_LOG.MESSAGE_ID is '消息标识'
/

comment on column SYS_ROCKET_MQ_CONSUME_LOG.MESSAGE_UUID is '消息UUID'
/

comment on column SYS_ROCKET_MQ_CONSUME_LOG.RECONSUME_TIMES is '消息标识'
/

comment on column SYS_ROCKET_MQ_CONSUME_LOG.CONSUMER_KEY is '消息体key'
/

