create table SYS_ROLE_OU
(
    ID                 NUMBER(19)    not null
        constraint PK_SYS_ROLE_OU
            primary key,
    OU_ID              NUMBER(19),
    OU_NAME            NVARCHAR2(32) not null,
    ROLE_ID            NUMBER(19),
    ROLE_NAME          NVARCHAR2(32) not null,
    ROLE_TYPE          NUMBER(10)    not null,
    USERNAME           NVARCHAR2(32) not null,
    LAST_NAME          NVARCHAR2(256),
    FIRST_NAME         NVARCHAR2(256),
    USER_ID            NUMBER(19),
    TENANT_ID          NUMBER(19),
    REMARK             NVARCHAR2(255),
    CREATE_USER_ID     NUMBER(19),
    CREATOR            NVARCHAR2(255),
    CREATE_TIME        DATE,
    MODIFY_USER_ID     NUMBER(19),
    UPDATER            NVARCHAR2(255),
    MODIFY_TIME        DATE,
    DELETE_FLAG        NUMBER(10)    not null,
    AUDIT_DATA_VERSION NUMBER(10),
    SEC_BU_ID          NUMBER(19),
    SEC_USER_ID        NUMBER(19),
    SEC_OU_ID          NUMBER(19)
)
/

comment on table SYS_ROLE_OU is '系统角色与公司表'
/

comment on column SYS_ROLE_OU.ID is '记录唯一ID'
/

comment on column SYS_ROLE_OU.OU_ID is '公司ID'
/

comment on column SYS_ROLE_OU.OU_NAME is '公司名称'
/

comment on column SYS_ROLE_OU.ROLE_ID is '角色ID'
/

comment on column SYS_ROLE_OU.ROLE_NAME is '角色名称'
/

comment on column SYS_ROLE_OU.ROLE_TYPE is '角色类型：0：应用角色，1 数据角色  目前仅支持数据角色'
/

comment on column SYS_ROLE_OU.USERNAME is '用户账号名称'
/

comment on column SYS_ROLE_OU.LAST_NAME is '用户姓氏'
/

comment on column SYS_ROLE_OU.FIRST_NAME is '用户名称'
/

comment on column SYS_ROLE_OU.USER_ID is '用户Id'
/

comment on column SYS_ROLE_OU.TENANT_ID is '租户ID'
/

comment on column SYS_ROLE_OU.REMARK is '备注'
/

comment on column SYS_ROLE_OU.CREATE_USER_ID is '记录创建者ID'
/

comment on column SYS_ROLE_OU.CREATOR is '记录创建者'
/

comment on column SYS_ROLE_OU.CREATE_TIME is '记录创建时间'
/

comment on column SYS_ROLE_OU.MODIFY_USER_ID is '记录最后更新者ID'
/

comment on column SYS_ROLE_OU.UPDATER is '记录最后更新者'
/

comment on column SYS_ROLE_OU.MODIFY_TIME is '记录最后更新时间'
/

comment on column SYS_ROLE_OU.DELETE_FLAG is '逻辑删除，0：未删除，1：已删除'
/

comment on column SYS_ROLE_OU.AUDIT_DATA_VERSION is '锁版本'
/

comment on column SYS_ROLE_OU.SEC_BU_ID is 'sec_bu_id'
/

comment on column SYS_ROLE_OU.SEC_USER_ID is 'sec_user_id'
/

comment on column SYS_ROLE_OU.SEC_OU_ID is 'sec_ou_id'
/

create unique index UK_AJAL0XJA8Q14KAPQPGXQ9HYNJ
    on SYS_ROLE_OU (USERNAME)
/

