create table SYS_ROLE_PERMISSION
(
    ID                 NUMBER(19) not null
        constraint PK_SYS_ROLE_PERMISSION
            primary key,
    ROLE_ID            NUMBER(19),
    PERMISSION_ID      NUMBER(19),
    TENANT_ID          NUMBER(19),
    REMARK             NVARCHAR2(255),
    CREATE_USER_ID     NUMBER(19),
    CREATE_TIME        DATE,
    MODIFY_USER_ID     NUMBER(19),
    MODIFY_TIME        DATE,
    DELETE_FLAG        NUMBER(10),
    AUDIT_DATA_VERSION NUMBER(10),
    CREATOR            NVARCHAR2(255),
    UPDATER            NVARCHAR2(255),
    SEC_BU_ID          NUMBER(19),
    SEC_USER_ID        NUMBER(19),
    SEC_OU_ID          NUMBER(19)
)
/

comment on table SYS_ROLE_PERMISSION is '角色权限关联表'
/

comment on column SYS_ROLE_PERMISSION.ID is '账号唯一ID'
/

comment on column SYS_ROLE_PERMISSION.ROLE_ID is '角色ID'
/

comment on column SYS_ROLE_PERMISSION.PERMISSION_ID is '权限ID'
/

comment on column SYS_ROLE_PERMISSION.TENANT_ID is '租户ID'
/

comment on column SYS_ROLE_PERMISSION.REMARK is '备注'
/

comment on column SYS_ROLE_PERMISSION.CREATE_USER_ID is '记录创建者ID'
/

comment on column SYS_ROLE_PERMISSION.CREATE_TIME is '记录创建时间'
/

comment on column SYS_ROLE_PERMISSION.MODIFY_USER_ID is '记录最后更新者ID'
/

comment on column SYS_ROLE_PERMISSION.MODIFY_TIME is '记录最后更新时间'
/

comment on column SYS_ROLE_PERMISSION.DELETE_FLAG is '逻辑删除，0：未删除，1：已删除'
/

comment on column SYS_ROLE_PERMISSION.AUDIT_DATA_VERSION is '版本'
/

comment on column SYS_ROLE_PERMISSION.CREATOR is '记录创建者'
/

comment on column SYS_ROLE_PERMISSION.UPDATER is '记录最后更新者'
/

comment on column SYS_ROLE_PERMISSION.SEC_BU_ID is 'sec_bu_id'
/

comment on column SYS_ROLE_PERMISSION.SEC_USER_ID is 'sec_user_id'
/

comment on column SYS_ROLE_PERMISSION.SEC_OU_ID is 'sec_ou_id'
/

create index IDX_SYS_ROLE_PERMISSION_CREAT0
    on SYS_ROLE_PERMISSION (CREATE_USER_ID)
/

create index IDX_ROLE_PERMISSION_ROLE
    on SYS_ROLE_PERMISSION (ROLE_ID)
/

create index IDX_SYS_ROLE_PERMISSION_SEC_U0
    on SYS_ROLE_PERMISSION (SEC_USER_ID)
/

create index IDX_SYS_ROLE_PERMISSION_SEC_O0
    on SYS_ROLE_PERMISSION (SEC_OU_ID)
/

create index IDX_SYS_ROLE_PERMISSION_SEC_B0
    on SYS_ROLE_PERMISSION (SEC_BU_ID)
/

create index IDX_ROLE_PERMISSION_PERMISSION
    on SYS_ROLE_PERMISSION (PERMISSION_ID)
/