create table SYS_ROLE_RESOURCES
(
    ID                 NUMBER(19) not null
        constraint PK_SYS_ROLE_RESOURCES
            primary key,
    ROLE_ID            NUMBER(19),
    RESOURCES_ID       NUMBER(19),
    TENANT_ID          NUMBER(19),
    REMARK             NVARCHAR2(255),
    CREATE_USER_ID     NUMBER(19),
    CREATOR            NVARCHAR2(255),
    CREATE_TIME        DATE,
    MODIFY_USER_ID     NUMBER(19),
    UPDATER            NVARCHAR2(255),
    MODIFY_TIME        DATE,
    DELETE_FLAG        NUMBER(10) not null,
    AUDIT_DATA_VERSION NUMBER(10),
    SEC_BU_ID          NUMBER(19),
    SEC_USER_ID        NUMBER(19),
    SEC_OU_ID          NUMBER(19)
)
/

comment on table SYS_ROLE_RESOURCES is '角色资源关联表'
/

comment on column SYS_ROLE_RESOURCES.ID is '记录唯一ID'
/

comment on column SYS_ROLE_RESOURCES.ROLE_ID is '角色ID'
/

comment on column SYS_ROLE_RESOURCES.RESOURCES_ID is '资源ID'
/

comment on column SYS_ROLE_RESOURCES.TENANT_ID is '租户ID'
/

comment on column SYS_ROLE_RESOURCES.REMARK is '备注'
/

comment on column SYS_ROLE_RESOURCES.CREATE_USER_ID is '记录创建者ID'
/

comment on column SYS_ROLE_RESOURCES.CREATOR is '记录创建者'
/

comment on column SYS_ROLE_RESOURCES.CREATE_TIME is '记录创建时间'
/

comment on column SYS_ROLE_RESOURCES.MODIFY_USER_ID is '记录最后更新者ID'
/

comment on column SYS_ROLE_RESOURCES.UPDATER is '记录最后更新者'
/

comment on column SYS_ROLE_RESOURCES.MODIFY_TIME is '记录最后更新时间'
/

comment on column SYS_ROLE_RESOURCES.DELETE_FLAG is '逻辑删除，0：未删除，1：已删除'
/

comment on column SYS_ROLE_RESOURCES.AUDIT_DATA_VERSION is '锁版本'
/

comment on column SYS_ROLE_RESOURCES.SEC_BU_ID is 'sec_bu_id'
/

comment on column SYS_ROLE_RESOURCES.SEC_USER_ID is 'sec_user_id'
/

comment on column SYS_ROLE_RESOURCES.SEC_OU_ID is 'sec_ou_id'
/

