create table SYS_SETTING
(
    ID                 NUMBER(19) not null
        constraint PK_SYS_SETTING
            primary key,
    SETTING_NO         NVARCHAR2(40),
    SETTING_NAME       NVARCHAR2(40),
    SETTING_TYPE       NVARCHAR2(40),
    SETTING_TYPE2      NVARCHAR2(40),
    SETTING_TYPE3      NVARCHAR2(40),
    SETTING_STATUS     NVARCHAR2(40),
    SETTING_DESC       NVARCHAR2(500),
    SETTING_VAL        NVARCHAR2(500),
    DEF_VAL            NVARCHAR2(100),
    SORT_NO            NUMBER(10),
    TENANT_ID          NUMBER(19),
    REMARK             NVARCHAR2(255),
    CREATE_USER_ID     NUMBER(19),
    CREATOR            NVARCHAR2(255),
    CREATE_TIME        DATE,
    MODIFY_USER_ID     NUMBER(19),
    UPDATER            NVARCHAR2(255),
    MODIFY_TIME        DATE,
    DELETE_FLAG        NUMBER(10),
    AUDIT_DATA_VERSION NUMBER(10),
    EMAIL              NVARCHAR2(32),
    SEC_BU_ID          NUMBER(19),
    SEC_USER_ID        NUMBER(19),
    SEC_OU_ID          NUMBER(19)
)
/

comment on table SYS_SETTING is '设置项'
/

comment on column SYS_SETTING.ID is '记录唯一ID'
/

comment on column SYS_SETTING.SETTING_NO is '设置编号'
/

comment on column SYS_SETTING.SETTING_NAME is '设置名'
/

comment on column SYS_SETTING.SETTING_TYPE is '设置类型'
/

comment on column SYS_SETTING.SETTING_TYPE2 is '设置类型2'
/

comment on column SYS_SETTING.SETTING_TYPE3 is '设置类型3'
/

comment on column SYS_SETTING.SETTING_STATUS is '设置状态'
/

comment on column SYS_SETTING.SETTING_DESC is '设置描述'
/

comment on column SYS_SETTING.SETTING_VAL is '设置值'
/

comment on column SYS_SETTING.DEF_VAL is '默认值'
/

comment on column SYS_SETTING.SORT_NO is '排序号'
/

comment on column SYS_SETTING.TENANT_ID is '租户ID'
/

comment on column SYS_SETTING.REMARK is '备注'
/

comment on column SYS_SETTING.CREATE_USER_ID is '记录创建者ID'
/

comment on column SYS_SETTING.CREATOR is '记录创建者'
/

comment on column SYS_SETTING.CREATE_TIME is '记录创建时间'
/

comment on column SYS_SETTING.MODIFY_USER_ID is '记录最后更新者ID'
/

comment on column SYS_SETTING.UPDATER is '记录最后更新者'
/

comment on column SYS_SETTING.MODIFY_TIME is '记录最后更新时间'
/

comment on column SYS_SETTING.DELETE_FLAG is '逻辑删除，0：未删除，1：已删除'
/

comment on column SYS_SETTING.AUDIT_DATA_VERSION is '锁版本'
/

comment on column SYS_SETTING.EMAIL is '设置类型3'
/

comment on column SYS_SETTING.SEC_BU_ID is 'sec_bu_id'
/

comment on column SYS_SETTING.SEC_USER_ID is 'sec_user_id'
/

comment on column SYS_SETTING.SEC_OU_ID is 'sec_ou_id'
/

create index IDX_SYS_SETTING_CREATE_USER_ID
    on SYS_SETTING (CREATE_USER_ID)
/

create index IDX_SYS_SETTING_SEC_USER_ID
    on SYS_SETTING (SEC_USER_ID)
/

create index IDX_SYS_SETTING_SEC_OU_ID
    on SYS_SETTING (SEC_OU_ID)
/

create index IDX_SYS_SETTING_SEC_BU_ID
    on SYS_SETTING (SEC_BU_ID)
/
