create table SYS_TENANT_DB_MIGRATE
(
    ID                  NUMBER(19)     not null
        constraint PK_SYS_TENANT_DB_MIGRATE
            primary key,
    SYS_TENANT_ID       NUMBER(19)     not null,
    APP_CODE            NVARCHAR2(255) not null,
    TENANT_ISOLATION    NVARCHAR2(32)  not null,
    DATABASE_SOURCE_ID  NUMBER(19),
    SCHEMA_NAME         NVARCHAR2(255) not null,
    MIGRATE_SUCCESS     NUMBER(3)      not null,
    MIGRATE_START_TIME  DATE,
    MIGRATE_FINISH_TIME DATE,
    FAIL_REASON         CLOB,
    TENANT_ID           NUMBER(19),
    REMARK              NVARCHAR2(255),
    CREATE_USER_ID      NUMBER(19),
    CREATOR             NVARCHAR2(255),
    CREATE_TIME         DATE,
    MODIFY_USER_ID      NUMBER(19),
    UPDATER             NVARCHAR2(255),
    MODIFY_TIME         DATE,
    DELETE_FLAG         NUMBER(10)     not null,
    AUDIT_DATA_VERSION  NUMBER(10),
    SEC_BU_ID           NUMBER(19),
    SEC_USER_ID         NUMBER(19),
    SEC_OU_ID           NUMBER(19)
)
/

comment on table SYS_TENANT_DB_MIGRATE is '租户数据库的创建记录'
/

comment on column SYS_TENANT_DB_MIGRATE.ID is '主键ID'
/

comment on column SYS_TENANT_DB_MIGRATE.SYS_TENANT_ID is '租户ID'
/

comment on column SYS_TENANT_DB_MIGRATE.APP_CODE is '应用编码'
/

comment on column SYS_TENANT_DB_MIGRATE.TENANT_ISOLATION is '租户数据隔离'
/

comment on column SYS_TENANT_DB_MIGRATE.DATABASE_SOURCE_ID is '租户数据隔离数据源'
/

comment on column SYS_TENANT_DB_MIGRATE.SCHEMA_NAME is 'schema名称，如果租户数据隔离通过schema'
/

comment on column SYS_TENANT_DB_MIGRATE.MIGRATE_SUCCESS is '是否迁移成功'
/

comment on column SYS_TENANT_DB_MIGRATE.MIGRATE_START_TIME is '迁移开始时间'
/

comment on column SYS_TENANT_DB_MIGRATE.MIGRATE_FINISH_TIME is '迁移结束时间'
/

comment on column SYS_TENANT_DB_MIGRATE.FAIL_REASON is '更新失败原因'
/

comment on column SYS_TENANT_DB_MIGRATE.TENANT_ID is '租户ID'
/

comment on column SYS_TENANT_DB_MIGRATE.REMARK is '备注'
/

comment on column SYS_TENANT_DB_MIGRATE.CREATE_USER_ID is '记录创建者ID'
/

comment on column SYS_TENANT_DB_MIGRATE.CREATOR is '记录创建者'
/

comment on column SYS_TENANT_DB_MIGRATE.CREATE_TIME is '记录创建时间'
/

comment on column SYS_TENANT_DB_MIGRATE.MODIFY_USER_ID is '记录最后更新者ID'
/

comment on column SYS_TENANT_DB_MIGRATE.UPDATER is '记录最后更新者'
/

comment on column SYS_TENANT_DB_MIGRATE.MODIFY_TIME is '记录最后更新时间'
/

comment on column SYS_TENANT_DB_MIGRATE.DELETE_FLAG is '逻辑删除，0：未删除，1：已删除'
/

comment on column SYS_TENANT_DB_MIGRATE.AUDIT_DATA_VERSION is '锁版本'
/

comment on column SYS_TENANT_DB_MIGRATE.SEC_BU_ID is 'sec_bu_id'
/

comment on column SYS_TENANT_DB_MIGRATE.SEC_USER_ID is 'sec_user_id'
/

comment on column SYS_TENANT_DB_MIGRATE.SEC_OU_ID is 'sec_ou_id'
/

create index IDX_TENANT_DB_MIGRATE_TENANT_I
    on SYS_TENANT_DB_MIGRATE (SYS_TENANT_ID)
/

