create table SYS_TENANT_USER
(
    ID                 NUMBER(19) not null
        constraint PK_SYS_TENANT_USER
            primary key,
    SYS_USER_ID        NUMBER(19) not null,
    SYS_TENANT_ID      NUMBER(19) not null,
    BIND_TIME          DATE,
    LAST_LOGIN_TIME    DATE,
    TENANT_ID          NUMBER(19),
    REMARK             NVARCHAR2(255),
    CREATE_USER_ID     NUMBER(19),
    CREATOR            NVARCHAR2(255),
    CREATE_TIME        DATE,
    MODIFY_USER_ID     NUMBER(19),
    UPDATER            NVARCHAR2(255),
    MODIFY_TIME        DATE,
    DELETE_FLAG        NUMBER(10) not null,
    AUDIT_DATA_VERSION NUMBER(10),
    SEC_BU_ID          NUMBER(19),
    SEC_USER_ID        NUMBER(19),
    SEC_OU_ID          NUMBER(19)
)
/

comment on table SYS_TENANT_USER is '用户与租户的绑定关系'
/

comment on column SYS_TENANT_USER.ID is '记录唯一ID'
/

comment on column SYS_TENANT_USER.SYS_USER_ID is '用户ID'
/

comment on column SYS_TENANT_USER.SYS_TENANT_ID is '租户ID'
/

comment on column SYS_TENANT_USER.BIND_TIME is '绑定时间'
/

comment on column SYS_TENANT_USER.LAST_LOGIN_TIME is '上次登录时间'
/

comment on column SYS_TENANT_USER.TENANT_ID is '租户ID'
/

comment on column SYS_TENANT_USER.REMARK is '备注'
/

comment on column SYS_TENANT_USER.CREATE_USER_ID is '记录创建者ID'
/

comment on column SYS_TENANT_USER.CREATOR is '记录创建者'
/

comment on column SYS_TENANT_USER.CREATE_TIME is '记录创建时间'
/

comment on column SYS_TENANT_USER.MODIFY_USER_ID is '记录最后更新者ID'
/

comment on column SYS_TENANT_USER.UPDATER is '记录最后更新者'
/

comment on column SYS_TENANT_USER.MODIFY_TIME is '记录最后更新时间'
/

comment on column SYS_TENANT_USER.DELETE_FLAG is '逻辑删除，0：未删除，1：已删除'
/

comment on column SYS_TENANT_USER.AUDIT_DATA_VERSION is '锁版本'
/

comment on column SYS_TENANT_USER.SEC_BU_ID is 'sec_bu_id'
/

comment on column SYS_TENANT_USER.SEC_USER_ID is 'sec_user_id'
/

comment on column SYS_TENANT_USER.SEC_OU_ID is 'sec_ou_id'
/

create index IDX_TENANT_USER_USER_ID
    on SYS_TENANT_USER (SYS_USER_ID)
/

create index IDX_TENANT_USER_TENANT_ID
    on SYS_TENANT_USER (SYS_TENANT_ID)
/