create table SYS_TENANT
(
    ID                 NUMBER(19)     not null
        constraint PK_SYS_TENANT
            primary key,
    TENANT_CODE        NVARCHAR2(255) not null,
    TENANT_NAME        NVARCHAR2(255) not null,
    SYS_USER_ID        NUMBER(19)     not null,
    ADMIN_ACCOUNT      NVARCHAR2(255) not null,
    TENANT_TYPE        NVARCHAR2(225) not null,
    ENABLED            NUMBER(3)      not null,
    LINKMAN            NVARCHAR2(255),
    CONTACT_NUMBER     NVARCHAR2(255),
    ADDRESS            NVARCHAR2(255),
    TENANT_ISOLATION   NVARCHAR2(32)  not null,
    DB_INITIALIZED     NUMBER(3)      not null,
    DATABASE_SOURCE_ID NUMBER(19),
    SCHEMA_NAME        NVARCHAR2(255) not null,
    TENANT_DOMAIN      NVARCHAR2(256),
    CUSTOM_DOMAIN      NVARCHAR2(400),
    TENANT_ID          NUMBER(19),
    REMARK             NVARCHAR2(255),
    CREATE_USER_ID     NUMBER(19),
    CREATOR            NVARCHAR2(255),
    CREATE_TIME        DATE,
    MODIFY_USER_ID     NUMBER(19),
    UPDATER            NVARCHAR2(255),
    MODIFY_TIME        DATE,
    DELETE_FLAG        NUMBER(10)     not null,
    AUDIT_DATA_VERSION NUMBER(10),
    SEC_BU_ID          NUMBER(19),
    SEC_USER_ID        NUMBER(19),
    SEC_OU_ID          NUMBER(19),
    INDUSTRY           VARCHAR2(255),
    CUSTOMER           VARCHAR2(255)
)
/

comment on table SYS_TENANT is '平台租户表'
/

comment on column SYS_TENANT.ID is '记录唯一ID'
/

comment on column SYS_TENANT.TENANT_CODE is '租户编码'
/

comment on column SYS_TENANT.TENANT_NAME is '租户名称'
/

comment on column SYS_TENANT.SYS_USER_ID is '管理员的用户ID'
/

comment on column SYS_TENANT.ADMIN_ACCOUNT is '管理员的登录账号'
/

comment on column SYS_TENANT.TENANT_TYPE is '租户类型'
/

comment on column SYS_TENANT.ENABLED is '是否启用'
/

comment on column SYS_TENANT.LINKMAN is '联系人'
/

comment on column SYS_TENANT.CONTACT_NUMBER is '联系电话'
/

comment on column SYS_TENANT.ADDRESS is '联系地址'
/

comment on column SYS_TENANT.TENANT_ISOLATION is '租户数据隔离'
/

comment on column SYS_TENANT.DB_INITIALIZED is '数据库是否已初始化'
/

comment on column SYS_TENANT.DATABASE_SOURCE_ID is '租户数据隔离数据源'
/

comment on column SYS_TENANT.SCHEMA_NAME is 'schema名称，如果租户数据隔离通过schema'
/

comment on column SYS_TENANT.TENANT_DOMAIN is '域名地址'
/

comment on column SYS_TENANT.CUSTOM_DOMAIN is '租户自定义域名'
/

comment on column SYS_TENANT.TENANT_ID is '租户ID'
/

comment on column SYS_TENANT.REMARK is '备注'
/

comment on column SYS_TENANT.CREATE_USER_ID is '记录创建者ID'
/

comment on column SYS_TENANT.CREATOR is '记录创建者'
/

comment on column SYS_TENANT.CREATE_TIME is '记录创建时间'
/

comment on column SYS_TENANT.MODIFY_USER_ID is '记录最后更新者ID'
/

comment on column SYS_TENANT.UPDATER is '记录最后更新者'
/

comment on column SYS_TENANT.MODIFY_TIME is '记录最后更新时间'
/

comment on column SYS_TENANT.DELETE_FLAG is '逻辑删除，0：未删除，1：已删除'
/

comment on column SYS_TENANT.AUDIT_DATA_VERSION is '锁版本'
/

comment on column SYS_TENANT.SEC_BU_ID is 'sec_bu_id'
/

comment on column SYS_TENANT.SEC_USER_ID is 'sec_user_id'
/

comment on column SYS_TENANT.SEC_OU_ID is 'sec_ou_id'
/

comment on column SYS_TENANT.INDUSTRY is '所属行业，[UDC]COM:INDUSTRY'
/

comment on column SYS_TENANT.CUSTOMER is '所属客户，[UDC]SYS:CUSTOMER'
/

create index IDX_SYS_TENANT_CODE
    on SYS_TENANT (TENANT_CODE)
/
