create table SYS_UDC
(
    ID                 NUMBER(19)    not null
        constraint PK_SYS_UDC
            primary key,
    DOMAIN_CODE        NVARCHAR2(32) not null,
    UDC_CODE           NVARCHAR2(32) not null,
    UDC_NAME           NVARCHAR2(64),
    UDC_VAL            NVARCHAR2(32) not null,
    VAL_DESC           NVARCHAR2(64) not null,
    VAL_SORT_NO        NUMBER(10),
    HD_FLAG            NUMBER(10),
    DP_FLAG            NUMBER(10),
    ES1                NVARCHAR2(32),
    ES2                NVARCHAR2(32),
    ES3                NVARCHAR2(32),
    ES4                NVARCHAR2(32),
    ES5                NVARCHAR2(32),
    ES6                NVARCHAR2(32),
    ES7                NVARCHAR2(32),
    ES8                NVARCHAR2(32),
    EF1                NUMBER(22),
    EF2                NUMBER(22),
    EF3                NUMBER(22),
    EF4                NUMBER(22),
    EI1                NUMBER(10),
    EI2                NUMBER(10),
    EI3                NUMBER(10),
    EI4                NUMBER(10),
    ED1                DATE,
    ED2                DATE,
    ED3                DATE,
    ED4                DATE,
    TENANT_ID          NUMBER(19),
    REMARK             NVARCHAR2(255),
    CREATE_USER_ID     NUMBER(19),
    CREATOR            NVARCHAR2(255),
    CREATE_TIME        DATE,
    MODIFY_USER_ID     NUMBER(19),
    UPDATER            NVARCHAR2(255),
    MODIFY_TIME        DATE,
    DELETE_FLAG        NUMBER(10),
    AUDIT_DATA_VERSION NUMBER(10),
    SEC_BU_ID          NUMBER(19),
    SEC_USER_ID        NUMBER(19),
    SEC_OU_ID          NUMBER(19)
)
/

comment on table SYS_UDC is '分类码表'
/

comment on column SYS_UDC.ID is '记录唯一ID'
/

comment on column SYS_UDC.DOMAIN_CODE is '领域码'
/

comment on column SYS_UDC.UDC_CODE is 'UDC码'
/

comment on column SYS_UDC.UDC_NAME is 'UDC码名称'
/

comment on column SYS_UDC.UDC_VAL is 'UDC值'
/

comment on column SYS_UDC.VAL_DESC is '值描述'
/

comment on column SYS_UDC.VAL_SORT_NO is '排序号'
/

comment on column SYS_UDC.HD_FLAG is '硬编码'
/

comment on column SYS_UDC.DP_FLAG is '是否开启数据权限'
/

comment on column SYS_UDC.ES1 is '扩展字段1-特殊处理'
/

comment on column SYS_UDC.ES2 is '扩展字段2'
/

comment on column SYS_UDC.ES3 is '扩展字段3'
/

comment on column SYS_UDC.ES4 is '扩展字段4'
/

comment on column SYS_UDC.ES5 is '扩展字段5'
/

comment on column SYS_UDC.ES6 is '扩展字段6'
/

comment on column SYS_UDC.ES7 is '扩展字段7'
/

comment on column SYS_UDC.ES8 is '扩展字段8'
/

comment on column SYS_UDC.EF1 is '扩展浮点1'
/

comment on column SYS_UDC.EF2 is '扩展浮点2'
/

comment on column SYS_UDC.EF3 is '扩展浮点3'
/

comment on column SYS_UDC.EF4 is '扩展浮点4'
/

comment on column SYS_UDC.EI1 is '扩展整数1'
/

comment on column SYS_UDC.EI2 is '扩展整数2'
/

comment on column SYS_UDC.EI3 is '扩展整数3'
/

comment on column SYS_UDC.EI4 is '扩展整数4'
/

comment on column SYS_UDC.ED1 is '扩展日期1'
/

comment on column SYS_UDC.ED2 is '扩展日期2'
/

comment on column SYS_UDC.ED3 is '扩展日期3'
/

comment on column SYS_UDC.ED4 is '扩展日期4'
/

comment on column SYS_UDC.TENANT_ID is '租户ID'
/

comment on column SYS_UDC.REMARK is '备注'
/

comment on column SYS_UDC.CREATE_USER_ID is '记录创建者ID'
/

comment on column SYS_UDC.CREATOR is '记录创建者'
/

comment on column SYS_UDC.CREATE_TIME is '记录创建时间'
/

comment on column SYS_UDC.MODIFY_USER_ID is '记录最后更新者ID'
/

comment on column SYS_UDC.UPDATER is '记录最后更新者'
/

comment on column SYS_UDC.MODIFY_TIME is '记录最后更新时间'
/

comment on column SYS_UDC.DELETE_FLAG is '逻辑删除，0：未删除，1：已删除'
/

comment on column SYS_UDC.AUDIT_DATA_VERSION is '锁版本'
/

comment on column SYS_UDC.SEC_BU_ID is 'sec_bu_id'
/

comment on column SYS_UDC.SEC_USER_ID is 'sec_user_id'
/

comment on column SYS_UDC.SEC_OU_ID is 'sec_ou_id'
/

create unique index UK_DOMAIN_CODE_VAL
    on SYS_UDC (DOMAIN_CODE, UDC_CODE, UDC_VAL)
/