create table SYS_USER_COMPANY
(
    ID                 NUMBER(19) not null
        constraint PK_SYS_USER_COMPANY
            primary key,
    SYS_USER_ID        NUMBER(19) not null,
    OU_ID              NUMBER(19) not null,
    OU_CODE            NVARCHAR2(255),
    OU_NAME            NVARCHAR2(255),
    BIND_TIME          DATE       not null,
    TENANT_ID          NUMBER(19),
    REMARK             NVARCHAR2(255),
    CREATE_USER_ID     NUMBER(19),
    CREATOR            NVARCHAR2(255),
    CREATE_TIME        DATE,
    MODIFY_USER_ID     NUMBER(19),
    UPDATER            NVARCHAR2(255),
    MODIFY_TIME        DATE,
    DELETE_FLAG        NUMBER(10) default '0',
    AUDIT_DATA_VERSION NUMBER(10),
    SEC_BU_ID          NUMBER(19),
    SEC_USER_ID        NUMBER(19),
    SEC_OU_ID          NUMBER(19)
)
/

comment on table SYS_USER_COMPANY is '用户与公司关联表'
/

comment on column SYS_USER_COMPANY.ID is '记录唯一ID'
/

comment on column SYS_USER_COMPANY.SYS_USER_ID is '用户ID'
/

comment on column SYS_USER_COMPANY.OU_ID is '公司ID'
/

comment on column SYS_USER_COMPANY.OU_CODE is '公司编码'
/

comment on column SYS_USER_COMPANY.OU_NAME is '公司名称'
/

comment on column SYS_USER_COMPANY.BIND_TIME is '绑定时间'
/

comment on column SYS_USER_COMPANY.TENANT_ID is '租户ID'
/

comment on column SYS_USER_COMPANY.REMARK is '备注'
/

comment on column SYS_USER_COMPANY.CREATE_USER_ID is '记录创建者ID'
/

comment on column SYS_USER_COMPANY.CREATOR is '记录创建者'
/

comment on column SYS_USER_COMPANY.CREATE_TIME is '记录创建时间'
/

comment on column SYS_USER_COMPANY.MODIFY_USER_ID is '记录最后更新者ID'
/

comment on column SYS_USER_COMPANY.UPDATER is '记录最后更新者'
/

comment on column SYS_USER_COMPANY.MODIFY_TIME is '记录最后更新时间'
/

comment on column SYS_USER_COMPANY.DELETE_FLAG is '逻辑删除，0：未删除，1：已删除'
/

comment on column SYS_USER_COMPANY.AUDIT_DATA_VERSION is '锁版本'
/

comment on column SYS_USER_COMPANY.SEC_BU_ID is 'sec_bu_id'
/

comment on column SYS_USER_COMPANY.SEC_USER_ID is 'sec_user_id'
/

comment on column SYS_USER_COMPANY.SEC_OU_ID is 'sec_ou_id'
/

create index IDX_SYS_USER_COMPANY_USER_ID
    on SYS_USER_COMPANY (SYS_USER_ID)
/

create index IDX_SYS_USER_COMPANY_OU_ID
    on SYS_USER_COMPANY (OU_ID)
/

