create table SYS_USER_DATA_ROLE
(
    ID                 NUMBER(19) not null
        constraint PK_SYS_USER_DATA_ROLE
            primary key,
    USER_ID            NUMBER(19),
    ROLE_ID            NUMBER(19),
    TENANT_ID          NUMBER(19),
    REMARK             NVARCHAR2(255),
    CREATE_USER_ID     NUMBER(19),
    CREATOR            NVARCHAR2(255),
    CREATE_TIME        DATE,
    MODIFY_USER_ID     NUMBER(19),
    UPDATER            NVARCHAR2(255),
    MODIFY_TIME        DATE,
    DELETE_FLAG        NUMBER(10) not null,
    AUDIT_DATA_VERSION NUMBER(10),
    SEC_BU_ID          NUMBER(19),
    SEC_USER_ID        NUMBER(19),
    SEC_OU_ID          NUMBER(19)
)
/

comment on table SYS_USER_DATA_ROLE is '用户数据角色关联表'
/

comment on column SYS_USER_DATA_ROLE.ID is '记录唯一ID'
/

comment on column SYS_USER_DATA_ROLE.USER_ID is '账号ID'
/

comment on column SYS_USER_DATA_ROLE.ROLE_ID is '数据角色ID'
/

comment on column SYS_USER_DATA_ROLE.TENANT_ID is '租户ID'
/

comment on column SYS_USER_DATA_ROLE.REMARK is '备注'
/

comment on column SYS_USER_DATA_ROLE.CREATE_USER_ID is '记录创建者ID'
/

comment on column SYS_USER_DATA_ROLE.CREATOR is '记录创建者'
/

comment on column SYS_USER_DATA_ROLE.CREATE_TIME is '记录创建时间'
/

comment on column SYS_USER_DATA_ROLE.MODIFY_USER_ID is '记录最后更新者ID'
/

comment on column SYS_USER_DATA_ROLE.UPDATER is '记录最后更新者'
/

comment on column SYS_USER_DATA_ROLE.MODIFY_TIME is '记录最后更新时间'
/

comment on column SYS_USER_DATA_ROLE.DELETE_FLAG is '逻辑删除，0：未删除，1：已删除'
/

comment on column SYS_USER_DATA_ROLE.AUDIT_DATA_VERSION is '锁版本'
/

comment on column SYS_USER_DATA_ROLE.SEC_BU_ID is 'sec_bu_id'
/

comment on column SYS_USER_DATA_ROLE.SEC_USER_ID is 'sec_user_id'
/

comment on column SYS_USER_DATA_ROLE.SEC_OU_ID is 'sec_ou_id'
/

create index IDX_SYS_USER_DATA_ROLE_CREATE0
    on SYS_USER_DATA_ROLE (CREATE_USER_ID)
/

create index IDX_SYS_USER_DATA_ROLE_SEC_US0
    on SYS_USER_DATA_ROLE (SEC_USER_ID)
/

create index IDX_SYS_USER_DATA_ROLE_SEC_OU0
    on SYS_USER_DATA_ROLE (SEC_OU_ID)
/

create index IDX_SYS_USER_DATA_ROLE_SEC_BU0
    on SYS_USER_DATA_ROLE (SEC_BU_ID)
/