create table SYS_USER_PROXY
(
    ID                 NUMBER(19)    not null
        constraint PK_SYS_USER_PROXY
            primary key,
    USER_ID            NUMBER(19),
    USERNAME           NVARCHAR2(32) not null,
    MOBILE             NVARCHAR2(16),
    EMAIL              NVARCHAR2(32),
    OU_ID              NUMBER(19),
    OU_CODE            NVARCHAR2(40),
    OU_NAME            NVARCHAR2(40),
    BU_ID              NUMBER(19),
    PROXY_USER_ID      NUMBER(19),
    PROXY_USERNAME     NVARCHAR2(32) not null,
    PROXY_MOBILE       NVARCHAR2(16),
    PROXY_EMAIL        NVARCHAR2(32),
    PROXY_OU_ID        NUMBER(19),
    PROXY_OU_CODE      NVARCHAR2(40),
    PROXY_OU_NAME      NVARCHAR2(40),
    PROXY_BU_ID        NUMBER(19),
    OPEN_FLAG          NUMBER(10),
    EFFECT_START_TIME  DATE,
    EFFECT_END_TIME    DATE,
    TENANT_ID          NUMBER(19),
    REMARK             NVARCHAR2(255),
    CREATE_USER_ID     NUMBER(19),
    CREATOR            NVARCHAR2(255),
    CREATE_TIME        DATE,
    MODIFY_USER_ID     NUMBER(19),
    UPDATER            NVARCHAR2(255),
    MODIFY_TIME        DATE,
    DELETE_FLAG        NUMBER(10)    not null,
    AUDIT_DATA_VERSION NUMBER(10),
    SEC_BU_ID          NUMBER(19),
    SEC_USER_ID        NUMBER(19),
    SEC_OU_ID          NUMBER(19)
)
/

comment on table SYS_USER_PROXY is '被代理用户与代理用户关系表'
/

comment on column SYS_USER_PROXY.ID is '记录唯一ID'
/

comment on column SYS_USER_PROXY.USER_ID is '被代理人id'
/

comment on column SYS_USER_PROXY.USERNAME is '被代理人用户账号名称'
/

comment on column SYS_USER_PROXY.MOBILE is '被代理人用户手机号码'
/

comment on column SYS_USER_PROXY.EMAIL is '被代理人用户邮箱地址'
/

comment on column SYS_USER_PROXY.OU_ID is '被代理人用户所属公司ID'
/

comment on column SYS_USER_PROXY.OU_CODE is '被代理人用户所属公司编号'
/

comment on column SYS_USER_PROXY.OU_NAME is '被代理人用户所属公司名称'
/

comment on column SYS_USER_PROXY.BU_ID is '被代理人用户所属组织ID'
/

comment on column SYS_USER_PROXY.PROXY_USER_ID is '代理人id'
/

comment on column SYS_USER_PROXY.PROXY_USERNAME is '代理人用户账号名称'
/

comment on column SYS_USER_PROXY.PROXY_MOBILE is '代理人用户手机号码'
/

comment on column SYS_USER_PROXY.PROXY_EMAIL is '代理人用户邮箱地址'
/

comment on column SYS_USER_PROXY.PROXY_OU_ID is '代理人用户所属公司ID'
/

comment on column SYS_USER_PROXY.PROXY_OU_CODE is '代理人用户所属公司编号'
/

comment on column SYS_USER_PROXY.PROXY_OU_NAME is '代理人用户所属公司名称'
/

comment on column SYS_USER_PROXY.PROXY_BU_ID is '代理人用户所属组织ID'
/

comment on column SYS_USER_PROXY.OPEN_FLAG is '是否开启-0：开启，1关闭'
/

comment on column SYS_USER_PROXY.EFFECT_START_TIME is '代理生效开始时间'
/

comment on column SYS_USER_PROXY.EFFECT_END_TIME is '代理生效结束时间'
/

comment on column SYS_USER_PROXY.TENANT_ID is '租户ID'
/

comment on column SYS_USER_PROXY.REMARK is '备注'
/

comment on column SYS_USER_PROXY.CREATE_USER_ID is '记录创建者ID'
/

comment on column SYS_USER_PROXY.CREATOR is '记录创建者'
/

comment on column SYS_USER_PROXY.CREATE_TIME is '记录创建时间'
/

comment on column SYS_USER_PROXY.MODIFY_USER_ID is '记录最后更新者ID'
/

comment on column SYS_USER_PROXY.UPDATER is '记录最后更新者'
/

comment on column SYS_USER_PROXY.MODIFY_TIME is '记录最后更新时间'
/

comment on column SYS_USER_PROXY.DELETE_FLAG is '逻辑删除，0：未删除，1：已删除'
/

comment on column SYS_USER_PROXY.AUDIT_DATA_VERSION is '锁版本'
/

comment on column SYS_USER_PROXY.SEC_BU_ID is 'sec_bu_id'
/

comment on column SYS_USER_PROXY.SEC_USER_ID is 'sec_user_id'
/

comment on column SYS_USER_PROXY.SEC_OU_ID is 'sec_ou_id'
/

create unique index UK_AL4CBI2JPU3DC3128LOMQ2S88
    on SYS_USER_PROXY (PROXY_USERNAME)
/

create unique index UK_ASMYOJ2XBIXIYVPYMEX71UIHG
    on SYS_USER_PROXY (USERNAME)
/

