create table SYS_USER_ROLE
(
    ID                 NUMBER(19) not null
        constraint PK_SYS_USER_ROLE
            primary key,
    USER_ID            NUMBER(19),
    ROLE_ID            NUMBER(19),
    TENANT_ID          NUMBER(19),
    REMARK             NVARCHAR2(255),
    CREATE_USER_ID     NUMBER(19),
    CREATE_TIME        DATE,
    MODIFY_USER_ID     NUMBER(19),
    MODIFY_TIME        DATE,
    DELETE_FLAG        NUMBER(10),
    AUDIT_DATA_VERSION NUMBER(10),
    CREATOR            NVARCHAR2(255),
    UPDATER            NVARCHAR2(255),
    SEC_BU_ID          NUMBER(19),
    SEC_USER_ID        NUMBER(19),
    SEC_OU_ID          NUMBER(19)
)
/

comment on table SYS_USER_ROLE is '用户角色关联表'
/

comment on column SYS_USER_ROLE.ID is '账号唯一ID'
/

comment on column SYS_USER_ROLE.USER_ID is '用户ID'
/

comment on column SYS_USER_ROLE.ROLE_ID is '角色ID'
/

comment on column SYS_USER_ROLE.TENANT_ID is '租户ID'
/

comment on column SYS_USER_ROLE.REMARK is '备注'
/

comment on column SYS_USER_ROLE.CREATE_USER_ID is '记录创建者ID'
/

comment on column SYS_USER_ROLE.CREATE_TIME is '记录创建时间'
/

comment on column SYS_USER_ROLE.MODIFY_USER_ID is '记录最后更新者ID'
/

comment on column SYS_USER_ROLE.MODIFY_TIME is '记录最后更新时间'
/

comment on column SYS_USER_ROLE.DELETE_FLAG is '逻辑删除，0：未删除，1：已删除'
/

comment on column SYS_USER_ROLE.AUDIT_DATA_VERSION is '版本'
/

comment on column SYS_USER_ROLE.CREATOR is '记录创建者'
/

comment on column SYS_USER_ROLE.UPDATER is '记录最后更新者'
/

comment on column SYS_USER_ROLE.SEC_BU_ID is 'sec_bu_id'
/

comment on column SYS_USER_ROLE.SEC_USER_ID is 'sec_user_id'
/

comment on column SYS_USER_ROLE.SEC_OU_ID is 'sec_ou_id'
/

create index IDX_SYS_USER_ROLE_CREATE_USER0
    on SYS_USER_ROLE (CREATE_USER_ID)
/

create index IDX_SYS_USER_ROLE_USER_ID
    on SYS_USER_ROLE (USER_ID)
/

create index IDX_SYS_USER_ROLE_ROLE_ID
    on SYS_USER_ROLE (ROLE_ID)
/

create index IDX_SYS_USER_ROLE_SEC_USER_ID
    on SYS_USER_ROLE (SEC_USER_ID)
/

create index IDX_SYS_USER_ROLE_SEC_OU_ID
    on SYS_USER_ROLE (SEC_OU_ID)
/

create index IDX_SYS_USER_ROLE_SEC_BU_ID
    on SYS_USER_ROLE (SEC_BU_ID)
/