create table SYS_USER
(
    ID                 NUMBER(19)     not null
        constraint PK_SYS_USER
            primary key
        constraint SYS_C0024642
            check ("ID" IS NOT NULL)
        constraint SYS_C0029093
            check ("ID" IS NOT NULL),
    USERNAME           NVARCHAR2(32)  not null
        constraint SYS_C0024643
            check ("USERNAME" IS NOT NULL)
        constraint SYS_C0029094
            check ("USERNAME" IS NOT NULL),
    LAST_NAME          NVARCHAR2(256),
    FIRST_NAME         NVARCHAR2(256),
    MOBILE             NVARCHAR2(16),
    EMAIL              NVARCHAR2(32),
    PASSWORD           NVARCHAR2(128) not null
        constraint SYS_C0024644
            check ("PASSWORD" IS NOT NULL)
        constraint SYS_C0029095
            check ("PASSWORD" IS NOT NULL),
    SOURCE_TYPE        NVARCHAR2(32),
    ENABLED            NUMBER(10),
    TRANS_FLAG         NUMBER(10) default '0',
    TENANT_ID          NUMBER(19),
    REMARK             NVARCHAR2(255),
    CREATE_USER_ID     NUMBER(19),
    CREATOR            NVARCHAR2(255),
    CREATE_TIME        DATE,
    MODIFY_USER_ID     NUMBER(19),
    UPDATER            NVARCHAR2(255),
    MODIFY_TIME        DATE,
    DELETE_FLAG        NUMBER(10),
    AUDIT_DATA_VERSION NUMBER(10),
    SEC_BU_ID          NUMBER(19),
    SEC_USER_ID        NUMBER(19),
    SEC_OU_ID          NUMBER(19),
    NEED_RESET         NUMBER(10),
    WX_OPENID          NVARCHAR2(128),
    OU_ID              NUMBER(19),
    OU_CODE            NVARCHAR2(40),
    OU_NAME            NVARCHAR2(40),
    BU_ID              NUMBER(19),
    AVATAR_URL         CLOB,
    AVATAR_CODE        NVARCHAR2(32),
    FULL_NAME          NVARCHAR2(40),
    USER_TYPE          NVARCHAR2(40),
    TENANT_NAME        NVARCHAR2(65)
)
/

comment on table SYS_USER is '系统用户账号表'
/

comment on column SYS_USER.ID is '记录唯一ID'
/

comment on column SYS_USER.USERNAME is '用户账号名称'
/

comment on column SYS_USER.LAST_NAME is '用户姓氏'
/

comment on column SYS_USER.FIRST_NAME is '用户名称'
/

comment on column SYS_USER.MOBILE is '用户手机号码'
/

comment on column SYS_USER.EMAIL is '用户邮箱地址'
/

comment on column SYS_USER.PASSWORD is '用户账号密码-hashed'
/

comment on column SYS_USER.SOURCE_TYPE is '账号来源, sys： 系统创建；wec：微信创建；oth：其他方式'
/

comment on column SYS_USER.ENABLED is '是否启用'
/

comment on column SYS_USER.TRANS_FLAG is '是否同步 0 未同步 1 已同步'
/

comment on column SYS_USER.TENANT_ID is '租户ID'
/

comment on column SYS_USER.REMARK is '备注'
/

comment on column SYS_USER.CREATE_USER_ID is '记录创建者ID'
/

comment on column SYS_USER.CREATOR is '记录创建者'
/

comment on column SYS_USER.CREATE_TIME is '记录创建时间'
/

comment on column SYS_USER.MODIFY_USER_ID is '记录最后更新者ID'
/

comment on column SYS_USER.UPDATER is '记录最后更新者'
/

comment on column SYS_USER.MODIFY_TIME is '记录最后更新时间'
/

comment on column SYS_USER.DELETE_FLAG is '逻辑删除，0：未删除，1：已删除'
/

comment on column SYS_USER.AUDIT_DATA_VERSION is '锁版本'
/

comment on column SYS_USER.SEC_BU_ID is 'sec_bu_id'
/

comment on column SYS_USER.SEC_USER_ID is 'sec_user_id'
/

comment on column SYS_USER.SEC_OU_ID is 'sec_ou_id'
/

comment on column SYS_USER.NEED_RESET is '密码是否需要重新设置'
/

comment on column SYS_USER.WX_OPENID is '微信poenid'
/

comment on column SYS_USER.OU_ID is '用户所属公司ID'
/

comment on column SYS_USER.OU_CODE is '用户所属公司编号'
/

comment on column SYS_USER.OU_NAME is '用户所属公司名称'
/

comment on column SYS_USER.BU_ID is '用户所属组织ID'
/

comment on column SYS_USER.AVATAR_URL is '用户头像地址，可直接访问，如微信头像地址等'
/

comment on column SYS_USER.AVATAR_CODE is '用户头像在文件服务器中的标识'
/

comment on column SYS_USER.FULL_NAME is '用户姓名'
/

comment on column SYS_USER.USER_TYPE is '用户类型'
/

comment on column SYS_USER.TENANT_NAME is '所属租户名称'
/

create index IDX_SYS_USER_CREATE_USER_ID
    on SYS_USER (CREATE_USER_ID)
/