create table SYS_WATERMARK_CONFIG
(
    ID                 NUMBER(19) not null
        constraint PK_SYS_WATERMARK_CONFIG
            primary key,
    CUSTOM_FIELD       NVARCHAR2(128),
    STACKING_DEEP      NUMBER(10),
    TENANT_ID          NUMBER(19),
    REMARK             NVARCHAR2(255),
    CREATE_USER_ID     NUMBER(19),
    CREATOR            NVARCHAR2(255),
    CREATE_TIME        DATE,
    MODIFY_USER_ID     NUMBER(19),
    UPDATER            NVARCHAR2(255),
    MODIFY_TIME        DATE,
    DELETE_FLAG        NUMBER(10) not null,
    AUDIT_DATA_VERSION NUMBER(10),
    SEC_BU_ID          NUMBER(19),
    SEC_USER_ID        NUMBER(19),
    SEC_OU_ID          NUMBER(19),
    FONT_SIZE          NUMBER(10),
    ROTATE             NUMBER(10),
    FIELD_SIZE         NUMBER(10),
    ROTATION_ANGLE     NUMBER(10),
    DYNAMIC_FONT       NVARCHAR2(128),
    FONT_COLOR         NVARCHAR2(255),
    DYNA_FONT          NVARCHAR2(255),
    DYNAMIC_FIELD      NVARCHAR2(128)
)
/

comment on table SYS_WATERMARK_CONFIG is '系统水印配置'
/

comment on column SYS_WATERMARK_CONFIG.ID is '记录唯一ID'
/

comment on column SYS_WATERMARK_CONFIG.CUSTOM_FIELD is '自定义文字'
/

comment on column SYS_WATERMARK_CONFIG.STACKING_DEEP is '层叠深度'
/

comment on column SYS_WATERMARK_CONFIG.TENANT_ID is '租户ID'
/

comment on column SYS_WATERMARK_CONFIG.REMARK is '备注'
/

comment on column SYS_WATERMARK_CONFIG.CREATE_USER_ID is '记录创建者ID'
/

comment on column SYS_WATERMARK_CONFIG.CREATOR is '记录创建者'
/

comment on column SYS_WATERMARK_CONFIG.CREATE_TIME is '记录创建时间'
/

comment on column SYS_WATERMARK_CONFIG.MODIFY_USER_ID is '记录最后更新者ID'
/

comment on column SYS_WATERMARK_CONFIG.UPDATER is '记录最后更新者'
/

comment on column SYS_WATERMARK_CONFIG.MODIFY_TIME is '记录最后更新时间'
/

comment on column SYS_WATERMARK_CONFIG.DELETE_FLAG is '逻辑删除，0：未删除，1：已删除'
/

comment on column SYS_WATERMARK_CONFIG.AUDIT_DATA_VERSION is '锁版本'
/

comment on column SYS_WATERMARK_CONFIG.SEC_BU_ID is 'sec_bu_id'
/

comment on column SYS_WATERMARK_CONFIG.SEC_USER_ID is 'sec_user_id'
/

comment on column SYS_WATERMARK_CONFIG.SEC_OU_ID is 'sec_ou_id'
/

comment on column SYS_WATERMARK_CONFIG.FONT_SIZE is '文字大小'
/

comment on column SYS_WATERMARK_CONFIG.ROTATE is '旋转角度'
/

comment on column SYS_WATERMARK_CONFIG.FIELD_SIZE is '文字大小'
/

comment on column SYS_WATERMARK_CONFIG.ROTATION_ANGLE is '旋转角度'
/

comment on column SYS_WATERMARK_CONFIG.DYNAMIC_FONT is '动态文字'
/

comment on column SYS_WATERMARK_CONFIG.FONT_COLOR is '颜色深浅'
/

comment on column SYS_WATERMARK_CONFIG.DYNA_FONT is '动态文字'
/

comment on column SYS_WATERMARK_CONFIG.DYNAMIC_FIELD is '动态文字'
/

