create table UNDO_LOG
(
    ID            NUMBER(19)     not null
        constraint PK_UNDO_LOG
            primary key,
    BRANCH_ID     NUMBER(19)     not null,
    XID           NVARCHAR2(100) not null,
    CONTEXT       NVARCHAR2(128) not null,
    ROLLBACK_INFO BLOB           not null,
    LOG_STATUS    NUMBER(10)     not null,
    LOG_CREATED   DATE           not null,
    LOG_MODIFIED  DATE           not null,
    EXT           NVARCHAR2(100)
)
/

comment on table UNDO_LOG is 'undo_log'
/

comment on column UNDO_LOG.ID is 'id'
/

comment on column UNDO_LOG.BRANCH_ID is 'branch_id'
/

comment on column UNDO_LOG.XID is 'xid'
/

comment on column UNDO_LOG.CONTEXT is 'context'
/

comment on column UNDO_LOG.ROLLBACK_INFO is 'rollback_info'
/

comment on column UNDO_LOG.LOG_STATUS is 'log_status'
/

comment on column UNDO_LOG.LOG_CREATED is 'log_created'
/

comment on column UNDO_LOG.LOG_MODIFIED is 'log_modified'
/

comment on column UNDO_LOG.EXT is 'ext'
/

create unique index UX_UNDO_LOG
    on UNDO_LOG (XID, BRANCH_ID)
/

