create table USER_JOIN_BUID
(
    ID                 NUMBER(19) not null
        constraint PK_USER_JOIN_BUID
            primary key,
    USERID             NUMBER(10),
    SEC_BUID           NUMBER(10),
    TENANT_ID          NUMBER(19),
    REMARK             NVARCHAR2(255),
    CREATE_USER_ID     NUMBER(19),
    CREATOR            NVARCHAR2(255),
    CREATE_TIME        DATE,
    MODIFY_USER_ID     NUMBER(19),
    UPDATER            NVARCHAR2(255),
    MODIFY_TIME        DATE,
    DELETE_FLAG        NUMBER(10) not null,
    AUDIT_DATA_VERSION NUMBER(10)
)
/

comment on table USER_JOIN_BUID is 'user_join_buid'
/

comment on column USER_JOIN_BUID.ID is '记录唯一ID'
/

comment on column USER_JOIN_BUID.USERID is 'userid'
/

comment on column USER_JOIN_BUID.SEC_BUID is 'sec_buid'
/

comment on column USER_JOIN_BUID.TENANT_ID is '租户ID'
/

comment on column USER_JOIN_BUID.REMARK is '备注'
/

comment on column USER_JOIN_BUID.CREATE_USER_ID is '记录创建者ID'
/

comment on column USER_JOIN_BUID.CREATOR is '记录创建者'
/

comment on column USER_JOIN_BUID.CREATE_TIME is '记录创建时间'
/

comment on column USER_JOIN_BUID.MODIFY_USER_ID is '记录最后更新者ID'
/

comment on column USER_JOIN_BUID.UPDATER is '记录最后更新者'
/

comment on column USER_JOIN_BUID.MODIFY_TIME is '记录最后更新时间'
/

comment on column USER_JOIN_BUID.DELETE_FLAG is '逻辑删除，0：未删除，1：已删除'
/

comment on column USER_JOIN_BUID.AUDIT_DATA_VERSION is '锁版本'
/

create index IDX_USER_JOIN_BUID_CREATE_USE0
    on USER_JOIN_BUID (CREATE_USER_ID)
/

