create table USER_JOIN_USERID
(
    ID                 NUMBER(10) not null
        constraint PK_USER_JOIN_USERID
            primary key,
    USERID             NUMBER(10),
    SEC_USERID         NUMBER(10),
    TENANT_ID          NUMBER(19),
    REMARK             NVARCHAR2(255),
    CREATE_USER_ID     NUMBER(19),
    CREATOR            NVARCHAR2(255),
    CREATE_TIME        DATE,
    MODIFY_USER_ID     NUMBER(19),
    UPDATER            NVARCHAR2(255),
    MODIFY_TIME        DATE,
    DELETE_FLAG        NUMBER(10) not null,
    AUDIT_DATA_VERSION NUMBER(10)
)
/

comment on table USER_JOIN_USERID is 'user_join_userid'
/

comment on column USER_JOIN_USERID.ID is 'id'
/

comment on column USER_JOIN_USERID.USERID is 'userid'
/

comment on column USER_JOIN_USERID.SEC_USERID is 'sec_userid'
/

comment on column USER_JOIN_USERID.TENANT_ID is '租户ID'
/

comment on column USER_JOIN_USERID.REMARK is '备注'
/

comment on column USER_JOIN_USERID.CREATE_USER_ID is '记录创建者ID'
/

comment on column USER_JOIN_USERID.CREATOR is '记录创建者'
/

comment on column USER_JOIN_USERID.CREATE_TIME is '记录创建时间'
/

comment on column USER_JOIN_USERID.MODIFY_USER_ID is '记录最后更新者ID'
/

comment on column USER_JOIN_USERID.UPDATER is '记录最后更新者'
/

comment on column USER_JOIN_USERID.MODIFY_TIME is '记录最后更新时间'
/

comment on column USER_JOIN_USERID.DELETE_FLAG is '逻辑删除，0：未删除，1：已删除'
/

comment on column USER_JOIN_USERID.AUDIT_DATA_VERSION is '锁版本'
/

create index IDX_USER_JOIN_USERID_CREATE_U0
    on USER_JOIN_USERID (CREATE_USER_ID)
/

create index USERID
    on USER_JOIN_USERID (USERID, SEC_USERID)
/

create index SEC_USERID
    on USER_JOIN_USERID (SEC_USERID)
/

