create table SYS_PURVIEW_SETTINGS
(
    ID                 NUMBER(20)    not null,
    PID                NUMBER(20)    not null,
    RID                NUMBER(20)    not null,
    APPTYPE            VARCHAR2(255) not null,
    APPSTATUS          VARCHAR2(255) not null,
    TENANT_ID          NUMBER(20),
    REMARK             VARCHAR2(255),
    CREATE_USER_ID     NUMBER(20),
    CREATOR            VARCHAR2(255),
    CREATE_TIME        DATE,
    MODIFY_USER_ID     NUMBER(20),
    UPDATER            VARCHAR2(255),
    MODIFY_TIME        DATE,
    DELETE_FLAG        NUMBER(11)    not null,
    AUDIT_DATA_VERSION NUMBER(11),
    SEC_BU_ID          NUMBER(20),
    SEC_USER_ID        NUMBER(20),
    SEC_OU_ID          NUMBER(20)
)
/

comment on table SYS_PURVIEW_SETTINGS is 'user关联数据'
/

comment on column SYS_PURVIEW_SETTINGS.ID is '记录唯一ID'
/

comment on column SYS_PURVIEW_SETTINGS.PID is '业务id'
/

comment on column SYS_PURVIEW_SETTINGS.RID is '用户id'
/

comment on column SYS_PURVIEW_SETTINGS.APPTYPE is 'app类型'
/

comment on column SYS_PURVIEW_SETTINGS.APPSTATUS is 'app状态'
/

comment on column SYS_PURVIEW_SETTINGS.TENANT_ID is '租户ID'
/

comment on column SYS_PURVIEW_SETTINGS.REMARK is '备注'
/

comment on column SYS_PURVIEW_SETTINGS.CREATE_USER_ID is '记录创建者ID'
/

comment on column SYS_PURVIEW_SETTINGS.CREATOR is '记录创建者'
/

comment on column SYS_PURVIEW_SETTINGS.CREATE_TIME is '记录创建时间'
/

comment on column SYS_PURVIEW_SETTINGS.MODIFY_USER_ID is '记录最后更新者ID'
/

comment on column SYS_PURVIEW_SETTINGS.UPDATER is '记录最后更新者'
/

comment on column SYS_PURVIEW_SETTINGS.MODIFY_TIME is '记录最后更新时间'
/

comment on column SYS_PURVIEW_SETTINGS.DELETE_FLAG is '逻辑删除，0：未删除，1：已删除'
/

comment on column SYS_PURVIEW_SETTINGS.AUDIT_DATA_VERSION is '锁版本'
/

comment on column SYS_PURVIEW_SETTINGS.SEC_BU_ID is 'sec_bu_id'
/

comment on column SYS_PURVIEW_SETTINGS.SEC_USER_ID is 'sec_user_id'
/

comment on column SYS_PURVIEW_SETTINGS.SEC_OU_ID is 'sec_ou_id'
/

