package com.elitesland.cloudt.context;

import com.elitesland.cloudt.context.util.DatetimeUtil;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.lang.NonNull;

import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * Cloudt Context主配置类.
 *
 * @author Kaiser（wang shao）
 * @date 2022/2/18
 */
@Configuration(proxyBeanMethods = false)
@Import(CloudtContextAutoConfiguration.JacksonConfiguration.class)
public class CloudtContextAutoConfiguration implements ApplicationContextAware {

    @Override
    public void setApplicationContext(@NonNull ApplicationContext applicationContext) throws BeansException {
        onApplicationContext(applicationContext);
    }

    private void onApplicationContext(ApplicationContext applicationContext) {
        SpringContextHolder.setApplicationContext(applicationContext);
    }

    @Configuration(proxyBeanMethods = false)
    static class JacksonConfiguration {

        @Bean
        public Jackson2ObjectMapperBuilderCustomizer jackson2ObjectMapperBuilderCustomizer() {
            return jacksonObjectMapperBuilder -> jacksonObjectMapperBuilder.failOnUnknownProperties(false)
                    .failOnEmptyBeans(false)
                    .serializerByType(Long.class, ToStringSerializer.instance)
                    .serializerByType(Long.TYPE, ToStringSerializer.instance)
                    .serializerByType(LocalDateTime.class, new LocalDateTimeSerializer(DatetimeUtil.FORMATTER_DATETIME))
                    .deserializerByType(LocalDateTime.class, new LocalDateTimeDeserializer(DatetimeUtil.FORMATTER_DATETIME))
                    .serializerByType(LocalDate.class, new LocalDateSerializer(DatetimeUtil.FORMATTER_DATE))
                    .deserializerByType(LocalDate.class, new LocalDateDeserializer(DatetimeUtil.FORMATTER_DATE));
        }

        @Bean
        public LocalDateTimeSerializer localDateTimeSerializer() {
            return new LocalDateTimeSerializer(DatetimeUtil.FORMATTER_DATETIME);
        }

        @Bean
        public LocalDateTimeDeserializer localDateTimeDeserializer() {
            return new LocalDateTimeDeserializer(DatetimeUtil.FORMATTER_DATETIME);
        }
    }
}
