package com.elitesland.cloudt.context.transaction;

import org.springframework.boot.context.properties.ConfigurationProperties;

import java.time.Duration;
import java.util.HashSet;
import java.util.Set;

/**
 * 事务配置.
 *
 * @author Kaiser（wang shao）
 * @date 2021/11/06
 */
@ConfigurationProperties(prefix = TransactionProperties.CONFIG_PREFIX)
public class TransactionProperties {

    static final String CONFIG_PREFIX = "elitesland.transaction";

    /**
     * 是否开启全局事务配置
     */
    private Boolean enable = true;

    /**
     * 切面切入点
     */
    private String pointcut = "* com.elitesland..service..impl.*ServiceImpl.*(..)";

    /**
     * 事务超时时间，-1表示不限制
     */
    private Duration timeout = Duration.ofSeconds(30);

    /**
     * required事务的方法前缀
     */
    private Set<String> requiredMethodPrefix = new HashSet<>();

    /**
     * 只读事务的方法前缀
     */
    private Set<String> readonlyMethodPrefix = new HashSet<>();

    public Boolean getEnable() {
        return enable;
    }

    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    public String getPointcut() {
        return pointcut;
    }

    public void setPointcut(String pointcut) {
        this.pointcut = pointcut;
    }

    public Duration getTimeout() {
        return timeout;
    }

    public void setTimeout(Duration timeout) {
        this.timeout = timeout;
    }

    public Set<String> getRequiredMethodPrefix() {
        return requiredMethodPrefix;
    }

    public void setRequiredMethodPrefix(Set<String> requiredMethodPrefix) {
        this.requiredMethodPrefix = requiredMethodPrefix;
    }

    public Set<String> getReadonlyMethodPrefix() {
        return readonlyMethodPrefix;
    }

    public void setReadonlyMethodPrefix(Set<String> readonlyMethodPrefix) {
        this.readonlyMethodPrefix = readonlyMethodPrefix;
    }
}
