/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.context;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class SpringContextHolder {
    private static final Logger log = LoggerFactory.getLogger(SpringContextHolder.class);
    private static ApplicationContext applicationContext;

    private SpringContextHolder() {
    }

    public static <T> T getBean(Class<T> clazz) {
        SpringContextHolder.assertContextInjected();
        Assert.notNull(clazz, (String)"bean\u7c7b\u578b\u4e3a\u7a7a");
        return (T)applicationContext.getBean(clazz);
    }

    public static Object getBean(String name) {
        SpringContextHolder.assertContextInjected();
        Assert.hasText((String)name, (String)"bean\u540d\u79f0\u4e3a\u7a7a");
        return applicationContext.getBean(name);
    }

    public static <T> T getBean(String name, Class<T> clazz) {
        SpringContextHolder.assertContextInjected();
        Assert.hasText((String)name, (String)"bean\u540d\u79f0\u4e3a\u7a7a");
        Assert.notNull(clazz, (String)"bean\u7c7b\u578b\u4e3a\u7a7a");
        return (T)applicationContext.getBean(name, clazz);
    }

    public static <T> Map<String, T> getBeans(Class<T> clazz) {
        SpringContextHolder.assertContextInjected();
        Assert.notNull(clazz, (String)"bean\u7c7b\u578b\u4e3a\u7a7a");
        return applicationContext.getBeansOfType(clazz);
    }

    public static String getProperty(String key) {
        return SpringContextHolder.getProperty(key, String.class, null);
    }

    public static String getProperty(String key, String defaultValue) {
        return SpringContextHolder.getProperty(key, String.class, defaultValue);
    }

    public static <T> T getProperty(String key, Class<T> valueType) {
        return SpringContextHolder.getProperty(key, valueType, null);
    }

    public static <T> T getProperty(String key, Class<T> valueType, T defaultValue) {
        Assert.hasText((String)key, (String)"key\u4e3a\u7a7a");
        Assert.notNull(valueType, (String)"\u503c\u7c7b\u578b\u4e3a\u7a7a");
        Environment environment = SpringContextHolder.getBean(Environment.class);
        Object value = environment.getProperty(key, valueType);
        if (defaultValue == null) {
            return (T)value;
        }
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof String && !StringUtils.hasText((String)((String)value))) {
            return defaultValue;
        }
        return (T)value;
    }

    public static void autowireBean(Object bean) {
        Assert.notNull((Object)bean, (String)"\u5bf9\u8c61\u4e3a\u7a7a");
        SpringContextHolder.assertContextInjected();
        applicationContext.getAutowireCapableBeanFactory().autowireBean(bean);
    }

    static void setApplicationContext(ApplicationContext applicationContext) {
        SpringContextHolder.applicationContext = applicationContext;
    }

    private static void assertContextInjected() {
        if (applicationContext == null) {
            throw new IllegalStateException("\u8bf7\u5148\u8bbe\u7f6eapplicationContext.");
        }
    }
}

