/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.context.spi.support;

import com.elitesland.cloudt.context.spi.support.ProviderWrapper;
import com.elitesland.cloudt.context.spi.support.SpiUtil;
import com.elitesland.yst.common.annotation.context.spi.Spi;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class ProviderInstanceHolder {
    private static final Logger log = LoggerFactory.getLogger(ProviderInstanceHolder.class);
    private static final Map<String, List<ProviderWrapper<?>>> CACHE = new ConcurrentHashMap();

    private ProviderInstanceHolder() {
    }

    public static <T> List<T> loadProviderInstances(@NonNull Class<T> serviceType, Boolean reload) {
        Assert.notNull(serviceType, (String)"serviceType\u4e3a\u7a7a");
        List<ProviderWrapper<?>> providerWrappers = ProviderInstanceHolder.findProvider(serviceType, reload);
        if (providerWrappers.isEmpty()) {
            return Collections.emptyList();
        }
        return providerWrappers.stream().map(ProviderWrapper::getProvider).collect(Collectors.toList());
    }

    public static <T> Optional<T> loadProviderInstance(@NonNull Class<T> serviceType, Boolean reload) {
        Assert.notNull(serviceType, (String)"serviceType\u4e3a\u7a7a");
        List<ProviderWrapper<?>> providerWrappers = ProviderInstanceHolder.findProvider(serviceType, reload);
        if (providerWrappers.isEmpty()) {
            return Optional.empty();
        }
        for (ProviderWrapper<?> providerWrapper : providerWrappers) {
            if (!providerWrapper.isPrimary()) continue;
            return Optional.of(providerWrapper.getProvider());
        }
        return Optional.of(providerWrappers.get(0).getProvider());
    }

    private static <T> List<ProviderWrapper<?>> findProvider(Class<T> serviceType, Boolean reload) {
        boolean loadCache = reload == null || reload == false;
        String serviceName = serviceType.getName();
        if (loadCache && CACHE.containsKey(serviceName)) {
            return CACHE.get(serviceName);
        }
        List<ProviderWrapper<?>> providers = ProviderInstanceHolder.load(serviceType);
        CACHE.put(serviceName, providers);
        return providers;
    }

    private static <T> List<ProviderWrapper<?>> load(Class<T> serviceType) {
        ArrayList providers = new ArrayList();
        Spi spi = SpiUtil.obtainAnnotationSingle(serviceType, Spi.class);
        for (T t : ServiceLoader.load(serviceType)) {
            providers.add(new ProviderWrapper<T>(t, spi));
        }
        ProviderInstanceHolder.dealSpiPrimary(providers, spi);
        providers.sort(Comparator.comparing(ProviderWrapper::getOrder, Comparator.reverseOrder()));
        return providers;
    }

    private static void dealSpiPrimary(List<ProviderWrapper<?>> providers, Spi spi) {
        if (spi == null || !StringUtils.hasText((String)spi.primary()) || providers.isEmpty()) {
            return;
        }
        for (ProviderWrapper<?> provider : providers) {
            if (!provider.getClazz().getName().equals(spi.primary())) continue;
            provider.setPrimary(true);
            return;
        }
        throw new IllegalStateException("\u672a\u627e\u5230\u9ed8\u8ba4\u7684\u5b9e\u73b0\u7c7b\uff1a" + spi.primary());
    }
}

