/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.context.threadpool;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.dtp.common.config.ThreadPoolProperties;
import com.dtp.core.DtpRegistry;
import com.dtp.core.thread.DtpExecutor;
import com.dtp.core.thread.ThreadPoolBuilder;
import java.util.Objects;
import java.util.concurrent.ThreadPoolExecutor;

public final class ThreadPoolHolder {
    private static final String THREAD_POOL_NAME = "cloudT-dtp-common";
    private static final String THREAD_PREFIX = "cloudT-common-";
    private static final int THREAD_MAX_SIZE = Runtime.getRuntime().availableProcessors();
    static boolean dtpEnabled = false;

    private ThreadPoolHolder() {
    }

    public static ThreadPoolExecutor createThreadPool() {
        return ThreadPoolHolder.createThreadPool(null, null, null);
    }

    public static ThreadPoolExecutor createThreadPool(String threadPrefix) {
        return ThreadPoolHolder.createThreadPool(threadPrefix, null, null);
    }

    public static ThreadPoolExecutor createThreadPool(String threadPrefix, Integer coreSize) {
        return ThreadPoolHolder.createThreadPool(threadPrefix, coreSize, null);
    }

    public static synchronized ThreadPoolExecutor createThreadPool(String threadPrefix, Integer coreSize, Integer maxSize) {
        threadPrefix = CharSequenceUtil.blankToDefault((CharSequence)threadPrefix, (String)THREAD_PREFIX);
        coreSize = (Integer)ObjectUtil.defaultIfNull((Object)coreSize, (Object)1);
        maxSize = (Integer)ObjectUtil.defaultIfNull((Object)maxSize, (Object)THREAD_MAX_SIZE);
        DtpExecutor executor = null;
        if (ThreadPoolHolder.existsRegistry(THREAD_POOL_NAME)) {
            executor = DtpRegistry.getExecutor((String)THREAD_POOL_NAME);
        }
        ThreadPoolProperties propUpdate = null;
        if (executor == null) {
            executor = ThreadPoolBuilder.newBuilder().threadPoolName(THREAD_POOL_NAME).threadFactory(threadPrefix).corePoolSize(Objects.requireNonNullElse(coreSize, 1).intValue()).maximumPoolSize(Objects.requireNonNullElse(maxSize, THREAD_MAX_SIZE).intValue()).buildDynamic();
        } else {
            propUpdate = new ThreadPoolProperties();
            propUpdate.setCorePoolSize(Objects.requireNonNullElse(coreSize, 1).intValue());
            propUpdate.setMaximumPoolSize(Objects.requireNonNullElse(maxSize, THREAD_MAX_SIZE).intValue());
            propUpdate.setThreadNamePrefix(threadPrefix);
        }
        if (dtpEnabled) {
            if (propUpdate == null) {
                DtpRegistry.register((DtpExecutor)executor, (String)"common");
            } else {
                DtpRegistry.refresh((DtpExecutor)executor, (ThreadPoolProperties)propUpdate);
            }
        }
        return executor;
    }

    private static boolean existsRegistry(String threadPoolName) {
        if (!dtpEnabled) {
            return false;
        }
        return DtpRegistry.listAllDtpNames().contains(threadPoolName);
    }
}

