/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.context.threadpool.support;

import cn.hutool.core.text.CharSequenceUtil;
import com.dtp.common.config.DtpProperties;
import com.dtp.common.config.ThreadPoolProperties;
import com.dtp.core.DtpRegistry;
import com.dtp.core.thread.DtpExecutor;
import com.dtp.core.thread.ThreadPoolBuilder;
import java.util.Collection;
import java.util.List;
import org.springframework.core.task.TaskExecutor;
import org.springframework.lang.NonNull;
import org.springframework.util.CollectionUtils;

public class CustomTaskExecutor
implements TaskExecutor {
    String threadPoolName = "cloudT-dtp-default";
    String threadPrefix = "cloudT-tp-";
    private DtpExecutor dtpExecutor;

    public CustomTaskExecutor(DtpProperties dtpProperties) {
        this.buildDtpExecutor(dtpProperties);
    }

    public void execute(@NonNull Runnable task) {
        if (this.dtpExecutor == null) {
            this.dtpExecutor = DtpRegistry.getExecutor((String)this.threadPoolName);
        }
        this.dtpExecutor.execute(task);
    }

    private void buildDtpExecutor(DtpProperties dtpProperties) {
        List executorsConfigs = dtpProperties.getExecutors();
        if (dtpProperties.isEnabled() && !CollectionUtils.isEmpty((Collection)executorsConfigs)) {
            for (ThreadPoolProperties executorsConfig : executorsConfigs) {
                if (!CharSequenceUtil.equals((CharSequence)executorsConfig.getThreadPoolName(), (CharSequence)this.threadPoolName)) continue;
                return;
            }
        }
        this.buildDefault();
        if (dtpProperties.isEnabled()) {
            DtpRegistry.register((DtpExecutor)this.dtpExecutor, (String)"cloudTConfiguration");
        }
    }

    private void buildDefault() {
        this.dtpExecutor = ThreadPoolBuilder.newBuilder().threadPoolName(this.threadPoolName).threadFactory(this.threadPrefix).corePoolSize(8).buildDynamic();
    }
}

