package com.elitesland.cloudt.tenant.config;

import com.elitesland.cloudt.tenant.core.common.ConstantTenant;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.time.Duration;

/**
 * 租户客户端配置属性.
 *
 * @author Kaiser（wang shao）
 * @date 2022/3/24
 */
@ConfigurationProperties(prefix = TenantClientProperties.CONFIG_PREFIX)
public class TenantClientProperties {

    static final String CONFIG_PREFIX = ConstantTenant.CONFIG_SERVICE_PREFIX + ".client";

    /**
     * 是否启用客户端
     */
    private boolean enabled = true;

    /**
     * 租户路径拦截
     */
    private String pathPattern = "/**";

    /**
     * 租户域名地址
     */
    private String tenantDomain = "tenant.elitesland.com";

    /**
     * 同步数据库信息重试次数，默认3次
     */
    private int syncDbRetryTimes = 3;

    /**
     * 失败后重试间隔，默认1分钟
     */
    private Duration retryInterval = Duration.ofMinutes(2);

    /**
     * 默认租户数据库连接，默认从数据源获取
     */
    private String defaultSchemaDbUrl;

    /**
     * 默认租户数据库用户，默认从数据源获取
     */
    private String defaultSchemaDbUser;

    /**
     * 默认租户数据库密码，默认从数据源获取
     */
    private String defaultSchemaDbPassword;

    public boolean isEnabled() {
        return enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getPathPattern() {
        return pathPattern;
    }

    public void setPathPattern(String pathPattern) {
        this.pathPattern = pathPattern;
    }

    public String getTenantDomain() {
        return tenantDomain;
    }

    public void setTenantDomain(String tenantDomain) {
        this.tenantDomain = tenantDomain;
    }

    public int getSyncDbRetryTimes() {
        return syncDbRetryTimes;
    }

    public void setSyncDbRetryTimes(int syncDbRetryTimes) {
        this.syncDbRetryTimes = syncDbRetryTimes;
    }

    public Duration getRetryInterval() {
        return retryInterval;
    }

    public void setRetryInterval(Duration retryInterval) {
        this.retryInterval = retryInterval;
    }

    public String getDefaultSchemaDbUrl() {
        return defaultSchemaDbUrl;
    }

    public void setDefaultSchemaDbUrl(String defaultSchemaDbUrl) {
        this.defaultSchemaDbUrl = defaultSchemaDbUrl;
    }

    public String getDefaultSchemaDbUser() {
        return defaultSchemaDbUser;
    }

    public void setDefaultSchemaDbUser(String defaultSchemaDbUser) {
        this.defaultSchemaDbUser = defaultSchemaDbUser;
    }

    public String getDefaultSchemaDbPassword() {
        return defaultSchemaDbPassword;
    }

    public void setDefaultSchemaDbPassword(String defaultSchemaDbPassword) {
        this.defaultSchemaDbPassword = defaultSchemaDbPassword;
    }
}
