package com.elitesland.cloudt.tenant.config.datasource;

import cn.hutool.core.text.CharSequenceUtil;
import lombok.extern.log4j.Log4j2;
import org.springframework.orm.jpa.vendor.Database;
import org.springframework.util.StringUtils;

/**
 * 数据源提供者的父类.
 *
 * @author Kaiser（wang shao）
 * @date 2022/3/25
 */
@Log4j2
public abstract class AbstractTenantDatasourceProvider {

    /**
     * 默认schema
     */
    private static String defaultSchema;

    private static String dbUrl;

    private static String dbUser;

    private static String dbPassword;

    private static Database databaseType;

    private AbstractTenantDatasourceProvider() {
    }

    public static String getDefaultSchema() {
        return defaultSchema;
    }

    public static void setDefaultSchema(String defaultSchema) {
        if (StringUtils.hasText(AbstractTenantDatasourceProvider.defaultSchema)
                || !StringUtils.hasText(defaultSchema)) {
            return;
        }

        AbstractTenantDatasourceProvider.defaultSchema = defaultSchema;
    }

    public static String getDbUrl() {
        return dbUrl;
    }

    public static void setDbUrl(String dbUrl) {
        if (StringUtils.hasText(AbstractTenantDatasourceProvider.dbUrl)
                || !StringUtils.hasText(dbUrl)) {
            return;
        }

        AbstractTenantDatasourceProvider.dbUrl = dbUrl;
    }

    public static String getDbUser() {
        return dbUser;
    }

    public static void setDbUser(String dbUser) {
        if (StringUtils.hasText(AbstractTenantDatasourceProvider.dbUser)
                || !StringUtils.hasText(dbUser)) {
            return;
        }

        AbstractTenantDatasourceProvider.dbUser = dbUser;
    }

    public static String getDbPassword() {
        return dbPassword;
    }

    public static void setDbPassword(String dbPassword) {
        if (StringUtils.hasText(AbstractTenantDatasourceProvider.dbPassword)
                || !StringUtils.hasText(dbPassword)) {
            return;
        }

        AbstractTenantDatasourceProvider.dbPassword = dbPassword;
    }

    public static Database getDatabaseType() {
        return databaseType;
    }

    public static void setDatabaseType(Database databaseType) {
        if (databaseType == null || AbstractTenantDatasourceProvider.databaseType != null ) {
            return;
        }
        AbstractTenantDatasourceProvider.databaseType = databaseType;
    }

    public static Database getDatabaseTypeByUrl(String url) {
        if (url == null) {
            return null;
        }
        int index = url.indexOf("://");

        String temp;
        if (index > 0) {
            temp = url.substring(0, index);
        } else {
            return null;
        }

        index = temp.lastIndexOf(":");
        if (index > 0) {
            temp = temp.substring(index + 1);
        }
        try {
            return Database.valueOf(temp.toUpperCase());
        } catch (IllegalArgumentException e) {
            log.error("解析数据库类型失败：{}", url);
            return null;
        }
    }

    public static String generateSwitchSchemaSql(Database databaseType, String schema) {
        switch (databaseType) {
            case MYSQL:
                return String.format("USE %s", schema);
            case ORACLE:
                return String.format("ALTER SESSION SET CURRENT_SCHEMA = %s", schema);
            default:
                throw new IllegalStateException("暂不支持数据库：" + databaseType.name());
        }
    }
}
