package com.elitesland.cloudt.tenant.config.support;

import com.elitesland.cloudt.context.threadpool.support.ContextTransfer;
import com.elitesland.yst.system.dto.SysTenantDTO;

/**
 * 租户上下文信息传递.
 *
 * @author Kaiser（wang shao）
 * @date 2022/3/30
 */
public class TenantContextTransfer implements ContextTransfer<SysTenantDTO> {

    @Override
    public SysTenantDTO getContext() {
        return TenantContextHolder.getCurrentTenant();
    }

    @Override
    public void setContext(SysTenantDTO context) {
        TenantContextHolder.setCurrentTenant(context);
    }

    @Override
    public void clearContext() {
        TenantContextHolder.clearCurrent();
    }
}
