package com.elitesland.cloudt.tenant.config.support;

import com.elitesland.cloudt.context.base.AbstractEnvironmentPostProcessor;
import com.elitesland.cloudt.tenant.config.datasource.hibernate.HibernateTenantDatasourceProvider;
import com.elitesland.cloudt.tenant.config.datasource.hibernate.HibernateTenantIdentifierResolver;
import org.hibernate.MultiTenancyStrategy;
import org.springframework.boot.SpringApplication;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.util.CollectionUtils;

import java.util.HashMap;
import java.util.Map;

/**
 * 租户相关默认环境变量设置.
 *
 * @author Kaiser（wang shao）
 * @date 2022/3/25
 */
public class TenantEnvironmentDefaultConfig extends AbstractEnvironmentPostProcessor {

    @Override
    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        MutablePropertySources propertySources = environment.getPropertySources();
        Map<String, Object> defaultProperties = createDefaultProperties(environment);

        if (!CollectionUtils.isEmpty(defaultProperties)) {
            addOrReplace(propertySources, defaultProperties);
        }
    }

    private Map<String, Object> createDefaultProperties(ConfigurableEnvironment environment) {
        Map<String, Object> defaultProperties = new HashMap<>(8);
        // hibernate开启多租户设置
        defaultProperties.put("spring.jpa.properties.hibernate.multiTenancy", MultiTenancyStrategy.SCHEMA.name());
        defaultProperties.put("spring.jpa.properties.hibernate.tenant_identifier_resolver", HibernateTenantIdentifierResolver.class.getName());
        defaultProperties.put("spring.jpa.properties.hibernate.multi_tenant_connection_provider", HibernateTenantDatasourceProvider.class.getName());

        // 关闭自动创建表结构
        defaultProperties.put("spring.jpa.hibernate.ddl-auto", "none");
        defaultProperties.put("spring.jpa.properties.hibernate.hbm2ddl.auto", "none");

        return defaultProperties;
    }
}
