/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.tenant.config.datasource;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.orm.jpa.vendor.Database;
import org.springframework.util.StringUtils;

public abstract class AbstractTenantDatasourceProvider {
    private static final Logger log = LogManager.getLogger(AbstractTenantDatasourceProvider.class);
    private static String defaultSchema;
    private static String dbUrl;
    private static String dbUser;
    private static String dbPassword;
    private static Database databaseType;

    private AbstractTenantDatasourceProvider() {
    }

    public static String getDefaultSchema() {
        return defaultSchema;
    }

    public static void setDefaultSchema(String defaultSchema) {
        if (StringUtils.hasText((String)AbstractTenantDatasourceProvider.defaultSchema) || !StringUtils.hasText((String)defaultSchema)) {
            return;
        }
        AbstractTenantDatasourceProvider.defaultSchema = defaultSchema;
    }

    public static String getDbUrl() {
        return dbUrl;
    }

    public static void setDbUrl(String dbUrl) {
        if (StringUtils.hasText((String)AbstractTenantDatasourceProvider.dbUrl) || !StringUtils.hasText((String)dbUrl)) {
            return;
        }
        AbstractTenantDatasourceProvider.dbUrl = dbUrl;
    }

    public static String getDbUser() {
        return dbUser;
    }

    public static void setDbUser(String dbUser) {
        if (StringUtils.hasText((String)AbstractTenantDatasourceProvider.dbUser) || !StringUtils.hasText((String)dbUser)) {
            return;
        }
        AbstractTenantDatasourceProvider.dbUser = dbUser;
    }

    public static String getDbPassword() {
        return dbPassword;
    }

    public static void setDbPassword(String dbPassword) {
        if (StringUtils.hasText((String)AbstractTenantDatasourceProvider.dbPassword) || !StringUtils.hasText((String)dbPassword)) {
            return;
        }
        AbstractTenantDatasourceProvider.dbPassword = dbPassword;
    }

    public static Database getDatabaseType() {
        return databaseType;
    }

    public static void setDatabaseType(Database databaseType) {
        if (databaseType == null || AbstractTenantDatasourceProvider.databaseType != null) {
            return;
        }
        AbstractTenantDatasourceProvider.databaseType = databaseType;
    }

    public static Database getDatabaseTypeByUrl(String url) {
        if (url == null) {
            return null;
        }
        int index = url.indexOf("://");
        if (index <= 0) {
            return null;
        }
        String temp = url.substring(0, index);
        index = temp.lastIndexOf(":");
        if (index > 0) {
            temp = temp.substring(index + 1);
        }
        try {
            return Database.valueOf((String)temp.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            log.error("\u89e3\u6790\u6570\u636e\u5e93\u7c7b\u578b\u5931\u8d25\uff1a{}", (Object)url);
            return null;
        }
    }

    public static String generateSwitchSchemaSql(Database databaseType, String schema) {
        switch (databaseType) {
            case MYSQL: {
                return String.format("USE %s", schema);
            }
            case ORACLE: {
                return String.format("ALTER SESSION SET CURRENT_SCHEMA = %s", schema);
            }
        }
        throw new IllegalStateException("\u6682\u4e0d\u652f\u6301\u6570\u636e\u5e93\uff1a" + databaseType.name());
    }
}

