/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.tenant.config.datasource.hibernate;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitesland.cloudt.tenant.config.datasource.AbstractTenantDatasourceProvider;
import com.elitesland.cloudt.tenant.config.support.TenantContextHolder;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.engine.jdbc.connections.internal.DriverManagerConnectionProviderImpl;
import org.hibernate.engine.jdbc.connections.spi.AbstractMultiTenantConnectionProvider;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.springframework.orm.jpa.vendor.Database;
import org.springframework.util.StringUtils;

public class HibernateTenantDatasourceProvider
extends AbstractMultiTenantConnectionProvider {
    private static final Logger log = LogManager.getLogger(HibernateTenantDatasourceProvider.class);
    private static final long serialVersionUID = -3009600657851822507L;
    private final Map<String, ConnectionProvider> connectionProviderMap = new HashMap<String, ConnectionProvider>();
    private final Map<String, Database> databaseMapMap = new HashMap<String, Database>();

    public Connection getConnection(String tenantIdentifier) throws SQLException {
        Connection connection = super.getConnection(tenantIdentifier);
        String schema = this.getTenantSchema();
        Database database = this.getDatabaseType(tenantIdentifier);
        log.info("use schema '{}' for tenant '{}'", (Object)schema, (Object)tenantIdentifier);
        String command = AbstractTenantDatasourceProvider.generateSwitchSchemaSql(database, schema);
        try (Statement statement = connection.createStatement();){
            statement.execute(command);
        }
        return connection;
    }

    protected ConnectionProvider getAnyConnectionProvider() {
        return this.getConnectionProvider("anonymous");
    }

    protected ConnectionProvider selectConnectionProvider(String tenantIdentifier) {
        return this.getConnectionProvider(tenantIdentifier);
    }

    private String getTenantSchema() {
        return Optional.ofNullable(TenantContextHolder.getCurrentTenant()).map(t -> {
            if (CharSequenceUtil.isBlank((CharSequence)t.getSchemaName())) {
                return null;
            }
            Object prefix = CharSequenceUtil.isBlank((CharSequence)AbstractTenantDatasourceProvider.getDefaultSchema()) ? "" : AbstractTenantDatasourceProvider.getDefaultSchema() + "_";
            return (String)prefix + t.getSchemaName();
        }).filter(StringUtils::hasText).orElse(AbstractTenantDatasourceProvider.getDefaultSchema());
    }

    private Database getDatabaseType(String tenantIdentifier) {
        return Optional.ofNullable(tenantIdentifier).map(this.databaseMapMap::get).orElseGet(() -> {
            Database db = AbstractTenantDatasourceProvider.getDatabaseType();
            this.databaseMapMap.put(tenantIdentifier, db);
            return db;
        });
    }

    private ConnectionProvider getConnectionProvider(String tenantIdentifier) {
        return Optional.ofNullable(tenantIdentifier).map(this.connectionProviderMap::get).orElseGet(() -> this.createNewConnectionProvider(tenantIdentifier));
    }

    private ConnectionProvider createNewConnectionProvider(String tenantIdentifier) {
        return Optional.ofNullable(tenantIdentifier).map(this::createConnectionProvider).map(connectionProvider -> {
            this.connectionProviderMap.put(tenantIdentifier, (ConnectionProvider)connectionProvider);
            return connectionProvider;
        }).orElseThrow(() -> new RuntimeException("Cannot create new connection provider for tenant: " + tenantIdentifier));
    }

    private ConnectionProvider createConnectionProvider(String tenantIdentifier) {
        return Optional.ofNullable(tenantIdentifier).map(this::getHibernatePropertiesForTenantId).map(this::initConnectionProvider).orElse(null);
    }

    private Properties getHibernatePropertiesForTenantId(String tenantId) {
        Properties properties = new Properties();
        properties.setProperty("hibernate.connection.url", AbstractTenantDatasourceProvider.getDbUrl());
        properties.setProperty("hibernate.connection.username", AbstractTenantDatasourceProvider.getDbUser());
        properties.setProperty("hibernate.connection.password", AbstractTenantDatasourceProvider.getDbPassword());
        return properties;
    }

    private ConnectionProvider initConnectionProvider(Properties hibernateProperties) {
        DriverManagerConnectionProviderImpl connectionProvider = new DriverManagerConnectionProviderImpl();
        connectionProvider.configure((Map)hibernateProperties);
        return connectionProvider;
    }
}

