package com.elitesland.cloudt.authorization.api.provider.config;

import com.elitesland.boot.autoconfigure.elasticsearch.annotation.EnableElasticsearch;
import com.elitesland.boot.autoconfigure.elasticsearch.config.ElasticsearchConfiguration;
import com.elitesland.cloudt.authorization.api.provider.config.system.ConfigProperties;
import com.elitesland.cloudt.authorization.api.provider.config.system.TenantProperties;
import com.elitesland.cloudt.authorization.api.provider.config.system.WechatProperties;
import com.elitesland.cloudt.authorization.api.provider.security.AuthenticationCheckService;
import com.elitesland.cloudt.authorization.api.provider.security.impl.TenantAuthenticationCheckServiceImpl;
import com.elitesland.cloudt.tenant.TenantClient;
import com.elitesland.yst.core.config.datasource.hibernate.QueryDSLConfig;
import com.elitesland.yst.core.provider.tenant.TenantClientProvider;
import lombok.extern.log4j.Log4j2;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.scheduling.annotation.EnableScheduling;

/**
 * 系统配置.
 *
 * @author Kaiser（wang shao）
 * @date 2021/12/30
 */
@EnableConfigurationProperties({ConfigProperties.class, WechatProperties.class, TenantProperties.class})
@Import({SystemConfig.JpaConfig.class, SystemConfig.ElasticsearchConfig.class})
@EnableScheduling
@EnableCaching
@Log4j2
public class SystemConfig {

    /**
     * 当存在租户时的配置
     */
    @ConditionalOnClass({TenantClient.class})
    static class TenantConfig {

        /**
         * 用户认证时租户相关检查
         *
         * @param tenantProperties
         * @param tenantClientProvider
         * @return
         */
        @Bean
        public AuthenticationCheckService tenantAuthenticationCheckService(TenantProperties tenantProperties,
                                                                           TenantClientProvider tenantClientProvider) {
            return new TenantAuthenticationCheckServiceImpl(tenantProperties, tenantClientProvider);
        }
    }

    /**
     * 当存在Elasticsearch时的配置
     */
    @ConditionalOnClass({ElasticsearchConfiguration.class})
    @EnableElasticsearch(basePackages = "com.elitesland.cloudt.authorization")
    static class ElasticsearchConfig {
    }

    /**
     * 当存在querydsl时的配置
     */
    @ConditionalOnClass({QueryDSLConfig.class})
    @Import({QueryDSLConfig.class})
    static class JpaConfig {
    }
}
