package com.elitesland.cloudt.authorization.api.provider.config.servlet;

import com.elitesland.cloudt.authorization.api.client.config.AuthorizationProperties;
import com.elitesland.cloudt.authorization.api.provider.provider.oauth2.client.OAuth2ClientProvider;
import com.elitesland.cloudt.authorization.api.provider.web.controller.OAuth2LoginSupportController;
import lombok.extern.log4j.Log4j2;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;

/**
 * OAuth2客户端配置.
 *
 * @author Kaiser（wang shao）
 * @date 2022/7/5
 */
@Log4j2
@ConditionalOnProperty(prefix = AuthorizationProperties.CONFIG_PREFIX + ".oauth2-client", name = "client-id")
@ConditionalOnWebApplication(type = ConditionalOnWebApplication.Type.SERVLET)
public class ServletOAuth2ClientConfig {

    private final AuthorizationProperties authorizationProperties;

    public ServletOAuth2ClientConfig(AuthorizationProperties authorizationProperties) {
        this.authorizationProperties = authorizationProperties;
    }

    @Bean
    public OAuth2ClientProvider oAuth2ClientProvider() {
        return new OAuth2ClientProvider(authorizationProperties);
    }

    @Bean
    public OAuth2LoginSupportController oAuth2SettingController(OAuth2ClientProvider oAuth2ClientProvider) {
        return new OAuth2LoginSupportController(oAuth2ClientProvider);
    }
}
