package com.elitesland.cloudt.authorization.api.provider.config.system;

import com.elitesland.cloudt.authorization.api.provider.config.system.captcha.CaptchaCodeEnum;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;

/**
 * 验证码配置.
 *
 * @author Kaiser（wang shao）
 * @date 2022/3/9
 */
@Data
public class CaptchaInfo implements Serializable {

    @Serial
    private static final long serialVersionUID = -3752325666699328465L;

    /**
     * 验证码配置
     */
    private CaptchaCodeEnum codeType;
    /**
     * 验证码有效期 分钟
     */
    private Long expiration = 2L;
    /**
     * 验证码内容长度
     */
    private int length = 2;
    /**
     * 验证码宽度
     */
    private int width = 111;
    /**
     * 验证码高度
     */
    private int height = 36;
}
