package com.elitesland.cloudt.authorization.api.provider.config.system;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

import java.io.Serializable;
import java.time.Duration;

/**
 * 授权中心配置.
 *
 * @author Kaiser（wang shao）
 * @date 2021/12/30
 */
@ConfigurationProperties(prefix = "elitesland.projects.authorization")
public class ConfigProperties implements Serializable {
    private static final long serialVersionUID = -3752325666699278465L;

    @NestedConfigurationProperty
    private final LoginProperties login = new LoginProperties();

    /**
     * 短信配置
     */
    private final Sms sms = new Sms();

    public LoginProperties getLogin() {
        return login;
    }

    public Sms getSms() {
        return sms;
    }

    public static class Sms implements Serializable {
        private static final long serialVersionUID = -5102684046554624297L;
        /**
         * 是否用于测试
         */
        private Boolean test = false;

        /**
         * 验证码有效时间
         */
        private Duration ttl = Duration.ofMinutes(1);

        /**
         * 验证码长度
         */
        private Integer captchaLength = 4;

        /**
         * 短信内容
         */
        private String formatContent = "短信验证码{0}，有效期{1}秒";

        public Boolean getTest() {
            return test;
        }

        public void setTest(Boolean test) {
            this.test = test;
        }

        public Duration getTtl() {
            return ttl;
        }

        public void setTtl(Duration ttl) {
            this.ttl = ttl;
        }

        public Integer getCaptchaLength() {
            return captchaLength;
        }

        public void setCaptchaLength(Integer captchaLength) {
            this.captchaLength = captchaLength;
        }

        public String getFormatContent() {
            return formatContent;
        }

        public void setFormatContent(String formatContent) {
            this.formatContent = formatContent;
        }
    }
}
