package com.elitesland.cloudt.authorization.api.provider.config.system;

import org.springframework.boot.context.properties.ConfigurationProperties;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * 微信小程序配置.
 *
 * @author Kaiser（wang shao）
 * @date 2022/01/10
 */
@ConfigurationProperties(prefix = "elitesland.wechat")
public class WechatProperties implements Serializable {

    private static final long serialVersionUID = 6248659068250008287L;

    /**
     * 微信配置
     */
    private final List<App> apps = new ArrayList<>(4);

    public List<App> getApps() {
        return apps;
    }

    public static class App implements Serializable {
        private static final long serialVersionUID = -8821581764160725358L;

        /**
         * 设置微信小程序的appid
         */
        private String appid;

        /**
         * 设置微信小程序的Secret
         */
        private String secret;

        /**
         * 设置微信小程序消息服务器配置的token
         */
        private String token;

        /**
         * 设置微信小程序消息服务器配置的EncodingAESKey
         */
        private String aesKey;

        /**
         * 消息格式，XML或者JSON
         */
        private String msgDataFormat;

        public String getAppid() {
            return appid;
        }

        public void setAppid(String appid) {
            this.appid = appid;
        }

        public String getSecret() {
            return secret;
        }

        public void setSecret(String secret) {
            this.secret = secret;
        }

        public String getToken() {
            return token;
        }

        public void setToken(String token) {
            this.token = token;
        }

        public String getAesKey() {
            return aesKey;
        }

        public void setAesKey(String aesKey) {
            this.aesKey = aesKey;
        }

        public String getMsgDataFormat() {
            return msgDataFormat;
        }

        public void setMsgDataFormat(String msgDataFormat) {
            this.msgDataFormat = msgDataFormat;
        }
    }
}
