package com.elitesland.cloudt.authorization.api.provider.model.bo;

import lombok.Data;

import java.io.Serializable;

/**
 * OAuth2客户端配置信息.
 *
 * @author Kaiser（wang shao）
 * @date 2022/7/5
 */
@Data
public class OAuth2ClientConfigBO implements Serializable {
    private static final long serialVersionUID = 8313295346446674341L;

    /**
     * 客户端ID
     */
    private String clientId;

    /**
     * 客户端secret
     */
    private String clientSecret;

    /**
     * 认证端口
     */
    private String authorizeEndpoint;

    /**
     * token端口
     */
    private String tokenEndpoint;

    public OAuth2ClientConfigBO copy() {
        OAuth2ClientConfigBO configBO = new OAuth2ClientConfigBO();
        configBO.setClientId(getClientId());
        configBO.setClientSecret(getClientSecret());
        configBO.setAuthorizeEndpoint(getAuthorizeEndpoint());
        configBO.setTokenEndpoint(getTokenEndpoint());

        return configBO;
    }
}
