package com.elitesland.cloudt.authorization.api.provider.model.entity;

import lombok.Data;
import lombok.experimental.Accessors;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * OAuth2用户授权项.
 * <p>
 * 根据Spring Authorization Server的脚本{@link org/springframework/security/oauth2/server/authorization/oauth2-authorization-consent-schema.sql}
 *
 * @author Kaiser（wang shao）
 * @date 2021/12/30
 */
@Data
@Entity
@org.hibernate.annotations.Table(appliesTo = "oauth2_authorization_consent", comment = "OAuth2用户授权项")
@Table(name = "oauth2_authorization_consent")
@Accessors(chain = true)
public class OAuth2AuthorizationConsentDO implements Serializable {
    private static final long serialVersionUID = -4861161165659314739L;

    @Id
    @Column(name = "id", updatable = false, nullable = false, columnDefinition = "varchar(100) comment '主键ID'")
    private String id;

    @Column(name = "registered_client_id", nullable = false, columnDefinition = "varchar(100) comment '注册的客户端ID' ")
    private String registeredClientId;

    @Column(name = "principal_name", nullable = false, columnDefinition = "varchar(200) comment '用户' ")
    private String principalName;

    @Column(name = "authorities", nullable = false, columnDefinition = "varchar(1000) comment '权限' ")
    private String authorities;
}
