package com.elitesland.cloudt.authorization.api.provider.model.entity;

import lombok.Data;
import lombok.experimental.Accessors;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * OAuth2用户授权项.
 * <p>
 * 根据Spring Authorization Server的脚本{@link org/springframework/security/oauth2/server/authorization/oauth2-authorization-schema.sql}
 *
 * @author Kaiser（wang shao）
 * @date 2021/12/30
 */
@Data
@Entity
@org.hibernate.annotations.Table(appliesTo = "oauth2_authorization", comment = "OAuth2用户授权项")
@Table(name = "oauth2_authorization")
@Accessors(chain = true)
public class OAuth2AuthorizationDO implements Serializable {
    private static final long serialVersionUID = -4861161165659314739L;

    @Id
    @Column(name = "id", updatable = false, nullable = false, columnDefinition = "varchar(100) comment '主键ID'")
    private String id;

    @Column(name = "registered_client_id", nullable = false, columnDefinition = "varchar(100) comment '注册的客户端ID' ")
    private String registeredClientId;

    @Column(name = "principal_name", nullable = false, columnDefinition = "varchar(200) comment '用户' ")
    private String principalName;

    @Column(name = "authorization_grant_type", nullable = false, columnDefinition = "varchar(100) comment '授权方式' ")
    private String authorizationGrantType;

    @Column(name = "attributes", columnDefinition = "text comment '属性' ")
    private String attributes;

    @Column(name = "state", columnDefinition = "varchar(500) comment '状态' ")
    private String state;

    @Column(name = "authorization_code_value", columnDefinition = "varchar(4000) comment '授权码' ")
    private String authorizationCodeValue;

    @Column(name = "authorization_code_issued_at", columnDefinition = "timestamp null default null comment '授权码颁发时间' ")
    private LocalDateTime authorizationCodeIssuedAt;

    @Column(name = "authorization_code_expires_at", columnDefinition = "timestamp null default null comment '授权码过期时间' ")
    private LocalDateTime authorizationCodeExpiresAt;

    @Column(name = "authorization_code_metadata", columnDefinition = "text comment '授权码元数据' ")
    private String authorizationCodeMetadata;

    @Column(name = "access_token_value", columnDefinition = "varchar(4000) comment 'AccessToken' ")
    private String accessTokenValue;

    @Column(name = "access_token_issued_at", columnDefinition = "timestamp null default null comment 'AccessToken颁发时间' ")
    private LocalDateTime accessTokenIssuedAt;

    @Column(name = "access_token_expires_at", columnDefinition = "timestamp null default null comment 'AccessToken过期时间' ")
    private LocalDateTime accessTokenExpiresAt;

    @Column(name = "access_token_metadata", columnDefinition = "text comment 'AccessToken元数据' ")
    private String accessTokenMetadata;

    @Column(name = "access_token_type", columnDefinition = "varchar(100) comment 'AccessToken类型' ")
    private String accessTokenType;

    @Column(name = "access_token_scopes", columnDefinition = "varchar(100) comment 'AccessToken范围' ")
    private String accessTokenScopes;

    @Column(name = "oidc_id_token_value", columnDefinition = "varchar(4000) comment 'oidc token' ")
    private String oidcIdTokenValue;

    @Column(name = "oidc_id_token_issued_at", columnDefinition = "timestamp null default null comment 'oidc颁发时间' ")
    private LocalDateTime oidcIdTokenIssuedAt;

    @Column(name = "oidc_id_token_expires_at", columnDefinition = "timestamp null default null comment 'oidc过期时间' ")
    private LocalDateTime oidcIdTokenExpiresAt;

    @Column(name = "oidc_id_token_metadata", columnDefinition = "text comment 'oidc元数据' ")
    private String oidcIdTokenMetadata;

    @Column(name = "refresh_token_value", columnDefinition = "varchar(4000) comment 'RefreshToken' ")
    private String refreshTokenValue;

    @Column(name = "refresh_token_issued_at", columnDefinition = "timestamp null default null comment 'RefreshToken颁发时间' ")
    private LocalDateTime refreshTokenIssuedAt;

    @Column(name = "refresh_token_expires_at", columnDefinition = "timestamp null default null comment 'RefreshToken过期时间' ")
    private LocalDateTime refreshTokenExpiresAt;

    @Column(name = "refresh_token_metadata", columnDefinition = "text comment 'RefreshToken元数据' ")
    private String refreshTokenMetadata;
}
