package com.elitesland.cloudt.authorization.api.provider.model.entity;

import lombok.Data;
import lombok.experimental.Accessors;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 注册的客户端.
 * <p>
 * 根据Spring Authorization Server的脚本{@link org/springframework/security/oauth2/server/authorization/client/oauth2-registered-client-schema.sql}
 *
 * @author Kaiser（wang shao）
 * @date 2021/12/30
 */
@Data
@Entity
@org.hibernate.annotations.Table(appliesTo = "oauth2_registered_client", comment = "OAuth2注册的客户端")
@Table(name = "oauth2_registered_client")
@Accessors(chain = true)
public class OAuth2RegisteredClientDO implements Serializable {
    private static final long serialVersionUID = 1641990646300458088L;

    @Id
    @Column(name = "id", updatable = false, nullable = false, columnDefinition = "varchar(100) comment '主键ID'")
    private String id;

    @Column(name = "client_id", nullable = false, columnDefinition = "varchar(100) comment '客户端ID' ")
    private String clientId;

    @Column(name = "client_id_issued_at", nullable = false, columnDefinition = "timestamp default current_timestamp comment '颁发时间' ")
    private LocalDateTime clientIdIssuedAt;

    @Column(name = "client_secret", nullable = false, columnDefinition = "varchar(200) comment '客户端密码' ")
    private String clientSecret;

    @Column(name = "client_secret_expires_at", columnDefinition = "timestamp null default null comment '密码过期时间' ")
    private LocalDateTime clientSecretExpiresAt;

    @Column(name = "client_name", nullable = false, columnDefinition = "varchar(200) comment '客户端名称' ")
    private String clientName;

    @Column(name = "client_authentication_methods", nullable = false, columnDefinition = "varchar(1000) comment '客户端认证方式' ")
    private String clientAuthenticationMethods;

    @Column(name = "authorization_grant_types", nullable = false, columnDefinition = "varchar(1000) comment '授权方式' ")
    private String authorizationGrantTypes;

    @Column(name = "redirect_uris", columnDefinition = "varchar(1000) comment '认证通过后重定向uri' ")
    private String redirectUris;

    @Column(name = "scopes", nullable = false, columnDefinition = "varchar(1000) comment '权限范围' ")
    private String scopes;

    @Column(name = "client_settings", nullable = false, columnDefinition = "varchar(2000) comment '客户端设置' ")
    private String clientSettings;

    @Column(name = "token_settings", nullable = false, columnDefinition = "varchar(2000) comment 'token设置' ")
    private String tokenSettings;
}
