package com.elitesland.cloudt.authorization.api.provider.provider.rmi.messenger;

import com.elitesland.cloudt.authorization.api.client.common.AuthorizationException;
import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.coord.messenger.sender.provider.MsgCarrierDubboService;
import com.elitesland.yst.coord.messenger.sender.provider.param.GeneralDubboCarrier;
import org.apache.dubbo.config.annotation.DubboReference;

import java.util.List;

/**
 * 消息服务接口.
 *
 * @author Kaiser（wang shao）
 * @date 2022/01/08
 */
public class RmiMsgCarrierDubboService {

    private static final String SERVER_ERROR_MSG = "消息中心异常";

    @DubboReference
    private MsgCarrierDubboService msgCarrierDubboService;

    public ApiResult<Object> generalSend(List<GeneralDubboCarrier> carriers) {
        try {
            return msgCarrierDubboService.generalSend(carriers);
        } catch (Exception e) {
            throw new AuthorizationException(SERVER_ERROR_MSG, e);
        }
    }
}
