package com.elitesland.cloudt.authorization.api.provider.provider.rmi.support;

import com.elitesland.cloudt.authorization.api.client.common.AuthorizationException;
import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.supportdomain.provider.org.dto.OrgUserEmpBuDTO;
import com.elitesland.yst.supportdomain.provider.org.service.OrgUserEmpBuRpcService;
import org.apache.dubbo.config.annotation.DubboReference;

/**
 * 远程调用支撑域员工组织服务.
 *
 * @author Kaiser（wang shao）
 * @date 2022/01/06
 */
public class RmiOrgUserEmpBuRpcService {

    private static final String SERVER_ERROR_MSG = "支撑域异常";

    @DubboReference
    private OrgUserEmpBuRpcService orgUserEmpBuRpcService;

    public ApiResult<OrgUserEmpBuDTO> findUserEmpBuInfoByUserId(Long userId) {
        try {
            return orgUserEmpBuRpcService.findUserEmpBuInfoByUserId(userId);
        } catch (Exception e) {
            throw new AuthorizationException(SERVER_ERROR_MSG, e);
        }
    }
}
