package com.elitesland.cloudt.authorization.api.provider.provider.wechat.dto;

import lombok.Data;

import java.io.Serial;
import java.io.Serializable;

/**
 * <pre>
 * code换取session_key接口的响应
 * 文档地址：https://mp.weixin.qq.com/debug/wxadoc/dev/api/api-login.html#wxloginobject
 * 微信返回报文：{"session_key":"nzoqhc3OnwHzeTxJs+inbQ==","openid":"oVBkZ0aYgDMDIywRdgPW8-joxXc4"}
 * </pre>
 *
 * @author <a href="https://github.com/binarywang">Binary Wang</a>
 */
@Data
public class WxMaJscode2SessionDTO implements Serializable {
    @Serial
    private static final long serialVersionUID = -1060216618475607933L;

    private String sessionKey;

    private String openid;

    private String unionid;
}