package com.elitesland.cloudt.authorization.api.provider.provider.wechat.provider;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.api.impl.WxMaServiceImpl;
import cn.binarywang.wx.miniapp.bean.WxMaJscode2SessionResult;
import cn.binarywang.wx.miniapp.config.impl.WxMaDefaultConfigImpl;
import com.elitesland.cloudt.authorization.api.provider.config.system.WechatProperties;
import com.elitesland.cloudt.authorization.api.provider.provider.rmi.system.RmiSysUserRpcService;
import com.elitesland.cloudt.authorization.api.provider.provider.wechat.WechatAppletService;
import com.elitesland.cloudt.authorization.api.provider.provider.wechat.dto.WxMaJscode2SessionDTO;
import com.elitesland.yst.common.base.ApiResult;
import lombok.extern.log4j.Log4j2;
import org.apache.commons.lang3.StringUtils;

import javax.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 微信小程序服务.
 *
 * @author Kaiser（wang shao）
 * @date 2022/01/10
 */
@Log4j2
public class WechatAppletServiceImpl implements WechatAppletService {

    private final RmiSysUserRpcService rmiSysUserRpcService;
    private final WechatProperties wechatProperties;

    private Map<String, WxMaService> maServices;

    public WechatAppletServiceImpl(RmiSysUserRpcService rmiSysUserRpcService, WechatProperties wechatProperties) {
        this.rmiSysUserRpcService = rmiSysUserRpcService;
        this.wechatProperties = wechatProperties;
    }

    @Override
    public ApiResult<WxMaJscode2SessionDTO> login(String appId, String code) {
        if (StringUtils.isBlank(code)) {
            return ApiResult.fail("code不能为空");
        }

        try {
            final WxMaService wxService = maServices.get(appId);
            WxMaJscode2SessionResult session = wxService.getUserService().getSessionInfo(code);
            WxMaJscode2SessionDTO wxMaJscode2SessionDTO = new WxMaJscode2SessionDTO();
            wxMaJscode2SessionDTO.setSessionKey(session.getSessionKey());
            wxMaJscode2SessionDTO.setOpenid(session.getOpenid());
            wxMaJscode2SessionDTO.setUnionid(session.getUnionid());
            return ApiResult.ok(wxMaJscode2SessionDTO);
        } catch (Exception e) {
            return ApiResult.fail(e.getMessage());
        }
    }

    @Override
    public ApiResult<String> sysUserBindingWx(String userName, String appId, String wxCode) {
        try {

            if (org.springframework.util.StringUtils.isEmpty(userName) || org.springframework.util.StringUtils.isEmpty(appId) || org.springframework.util.StringUtils.isEmpty(wxCode)) {
                return ApiResult.fail("绑定的Username微信appId或code不正确");
            }
            ApiResult<WxMaJscode2SessionDTO> wxApiResult =
                    this.login(appId, wxCode);
            if (wxApiResult.isSuccess()) {
                WxMaJscode2SessionDTO wxMaJscode2SessionResult = wxApiResult.getData();
                if (wxMaJscode2SessionResult != null && wxMaJscode2SessionResult.getOpenid() != null) {
                    return rmiSysUserRpcService.updateUserWechatOpenid(userName, wxMaJscode2SessionResult.getOpenid());
                } else {
                    return ApiResult.fail("微信认证失败:没有获取到openid");
                }
            } else {
                return ApiResult.fail("微信认证失败:" + wxApiResult.getErrorMsg() + wxApiResult.getMsg());
            }
        } catch (Exception e) {
            return ApiResult.fail("微信绑定异常:" + e.getMessage());
        }
    }

    @PostConstruct
    private void init() {
        List<WechatProperties.App> configs = this.wechatProperties.getApps();
        if (configs.isEmpty()) {
            WechatProperties.App config = new WechatProperties.App();
            config.setAppid("");
            config.setSecret("");
            config.setMsgDataFormat("JSON");
            configs = new ArrayList<>();
            configs.add(config);
        }

        maServices = configs.stream()
                .map(a -> {
                    WxMaDefaultConfigImpl config = new WxMaDefaultConfigImpl();
                    // 使用上面的配置时，需要同时引入jedis-lock的依赖，否则会报类无法找到的异常
                    config.setAppid(a.getAppid());
                    config.setSecret(a.getSecret());
                    config.setToken(a.getToken());
                    config.setAesKey(a.getAesKey());
                    config.setMsgDataFormat(a.getMsgDataFormat());

                    WxMaService service = new WxMaServiceImpl();
                    service.setWxMaConfig(config);
                    return service;
                }).collect(Collectors.toMap(s -> s.getWxMaConfig().getAppid(), a -> a));
    }
}
