package com.elitesland.cloudt.authorization.api.provider.security;

import com.elitesland.cloudt.authorization.api.provider.security.grant.AbstractCustomAuthenticationToken;
import com.elitesland.yst.security.entity.GeneralUserDetails;
import org.springframework.security.core.AuthenticationException;

/**
 * 身份认证的参数检查.
 *
 * @author Kaiser（wang shao）
 * @date 2022/6/20
 */
public interface AuthenticationCheckService<T extends AbstractCustomAuthenticationToken> {

    /**
     * 扩展信息检查
     *
     * @param userDetails    用户信息
     * @param authentication 认证令牌
     * @throws AuthenticationException 认证异常
     */
    void additionalAuthenticationChecks(GeneralUserDetails userDetails, T authentication) throws AuthenticationException;
}
