package com.elitesland.cloudt.authorization.api.provider.security.configurer;

import com.elitesland.cloudt.authorization.api.provider.security.configurer.filter.OAuth2AuthorizationCodeStateAuthenticationFilter;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.config.ProviderSettings;
import org.springframework.security.web.authentication.logout.LogoutFilter;

/**
 * 对于不支持redirect功能的终端支持通过state维持认证前后状态.
 *
 * @author Kaiser（wang shao）
 * @date 2022/7/4
 */
public class OAuth2AuthorizationCodeStateFilterSecurityConfigurer<H extends HttpSecurityBuilder<H>>
        extends AbstractHttpConfigurer<OAuth2AuthorizationCodeStateFilterSecurityConfigurer<H>, H> {

    @Override
    public void init(H http) throws Exception {
        super.init(http);
    }

    @Override
    public void configure(H http) throws Exception {
        ProviderSettings providerSettings = http.getSharedObject(ProviderSettings.class);
        OAuth2AuthorizationService authorizationService = http.getSharedObject(OAuth2AuthorizationService.class);
        OAuth2AuthorizationCodeStateAuthenticationFilter authenticationFilter = new OAuth2AuthorizationCodeStateAuthenticationFilter(providerSettings.getAuthorizationEndpoint(), authorizationService);
        http.addFilterBefore(authenticationFilter, LogoutFilter.class);

        super.configure(http);
    }
}
