package com.elitesland.cloudt.authorization.api.provider.security.grant.client_user;

import com.elitesland.cloudt.authorization.api.client.common.AuthorizationException;
import com.elitesland.cloudt.authorization.api.provider.security.grant.AbstractCustomAuthenticationProvider;
import com.elitesland.yst.security.entity.GeneralUserDetails;
import lombok.extern.log4j.Log4j2;
import org.springframework.lang.NonNull;
import org.springframework.security.core.AuthenticationException;
import org.springframework.util.StringUtils;

/**
 * 客户端用户的身份认证.
 *
 * @author Kaiser（wang shao）
 * @date 2022/01/01
 */
@Log4j2
public class ClientUserAuthenticationProvider extends AbstractCustomAuthenticationProvider<ClientUserAuthenticationToken> {

    @NonNull
    @Override
    protected GeneralUserDetails retrieveUser(ClientUserAuthenticationToken authentication) throws AuthenticationException {
        String username = (String) authentication.getPrincipal();
        if (!StringUtils.hasText(username)) {
            throw new AuthorizationException("未知用户");
        }

        return userDetailManager.loadUserByUsername(username);
    }
}
